/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.base.Preconditions;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.NullableBooleanState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.Objects;

public class NullableBooleanStateSerializer
implements AccumulatorStateSerializer<NullableBooleanState> {
    private final Type type;

    @UsedByGeneratedCode
    public NullableBooleanStateSerializer() {
        this((Type)BooleanType.BOOLEAN);
    }

    public NullableBooleanStateSerializer(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getJavaType() == Boolean.TYPE ? 1 : 0) != 0, (Object)("Type must use boolean stack type: " + type));
    }

    public Type getSerializedType() {
        return this.type;
    }

    public void serialize(NullableBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BooleanType.BOOLEAN.writeBoolean(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, NullableBooleanState state) {
        if (block.isNull(index)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(BooleanType.BOOLEAN.getBoolean(block, index));
        }
    }
}

