/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.base.Preconditions;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.Objects;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    private final Type type;

    @UsedByGeneratedCode
    public NullableDoubleStateSerializer() {
        this((Type)DoubleType.DOUBLE);
    }

    public NullableDoubleStateSerializer(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getJavaType() == Double.TYPE ? 1 : 0) != 0, (Object)("Type must use double stack type: " + type));
    }

    public Type getSerializedType() {
        return this.type;
    }

    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.type.writeDouble(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, NullableDoubleState state) {
        if (block.isNull(index)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(this.type.getDouble(block, index));
        }
    }
}

