/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;

public interface PositionsAppender {
    public void appendTo(IntArrayList var1, Block var2, BlockBuilder var3);

    public static class TypedPositionsAppender
    implements PositionsAppender {
        private final Type type;

        public TypedPositionsAppender(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public void appendTo(IntArrayList positions, Block source, BlockBuilder target) {
            int[] positionArray = positions.elements();
            for (int i = 0; i < positions.size(); ++i) {
                this.type.appendTo(source, positionArray[i], target);
            }
        }
    }
}

