/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import io.airlift.bytecode.DynamicClassLoader;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VariableWidthType;
import io.trino.sql.gen.IsolatedClass;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.Optional;

public class PositionsAppenderFactory {
    private final NonEvictableLoadingCache<CacheKey, PositionsAppender> cache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.createAppender(key.type)));

    public PositionsAppender create(Type type, Class<? extends Block> blockClass) {
        return (PositionsAppender)this.cache.getUnchecked((Object)new CacheKey(type, blockClass));
    }

    private PositionsAppender createAppender(Type type) {
        return Optional.ofNullable(this.findDedicatedAppenderClassFor(type)).map(this::isolateAppender).orElseGet(() -> this.isolateTypeAppender(type));
    }

    private Class<? extends PositionsAppender> findDedicatedAppenderClassFor(Type type) {
        if (type instanceof FixedWidthType) {
            switch (((FixedWidthType)type).getFixedSize()) {
                case 1: {
                    return BytePositionsAppender.class;
                }
                case 2: {
                    return SmallintPositionsAppender.class;
                }
                case 4: {
                    return IntPositionsAppender.class;
                }
                case 8: {
                    return LongPositionsAppender.class;
                }
                case 12: {
                    return Int96PositionsAppender.class;
                }
                case 16: {
                    return Int128PositionsAppender.class;
                }
            }
        } else if (type instanceof VariableWidthType) {
            return SlicePositionsAppender.class;
        }
        return null;
    }

    private PositionsAppender isolateTypeAppender(Type type) {
        Class<? extends PositionsAppender> isolatedAppenderClass = this.isolateAppenderClass(PositionsAppender.TypedPositionsAppender.class);
        try {
            return isolatedAppenderClass.getConstructor(Type.class).newInstance(type);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private PositionsAppender isolateAppender(Class<? extends PositionsAppender> appenderClass) {
        Class<? extends PositionsAppender> isolatedAppenderClass = this.isolateAppenderClass(appenderClass);
        try {
            return isolatedAppenderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends PositionsAppender> isolateAppenderClass(Class<? extends PositionsAppender> appenderClass) {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(PositionsAppender.class.getClassLoader());
        Class<? extends PositionsAppender> isolatedBatchPositionsTransferClass = IsolatedClass.isolateClass(dynamicClassLoader, PositionsAppender.class, appenderClass, new Class[0]);
        return isolatedBatchPositionsTransferClass;
    }

    private static class CacheKey {
        private final Type type;
        private final Class<? extends Block> blockClass;

        private CacheKey(Type type, Class<? extends Block> blockClass) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.blockClass = Objects.requireNonNull(blockClass, "blockClass is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.type.equals(cacheKey.type) && this.blockClass.equals(cacheKey.blockClass);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.blockClass);
        }
    }

    public static class Int128PositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeLong(block.getLong(position, 0));
                    blockBuilder.writeLong(block.getLong(position, 8));
                    blockBuilder.closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    blockBuilder.writeLong(block.getLong(position, 0));
                    blockBuilder.writeLong(block.getLong(position, 8));
                    blockBuilder.closeEntry();
                }
            }
        }
    }

    public static class Int96PositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeLong(block.getLong(position, 0));
                    blockBuilder.writeInt(block.getInt(position, 8));
                    blockBuilder.closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    blockBuilder.writeLong(block.getLong(position, 0));
                    blockBuilder.writeInt(block.getInt(position, 8));
                    blockBuilder.closeEntry();
                }
            }
        }
    }

    public static class SmallintPositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeShort((int)block.getShort(position, 0)).closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    blockBuilder.writeShort((int)block.getShort(positionArray[i], 0)).closeEntry();
                }
            }
        }
    }

    public static class SlicePositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
                    blockBuilder.closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
                    blockBuilder.closeEntry();
                }
            }
        }
    }

    public static class BytePositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeByte((int)block.getByte(position, 0)).closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    blockBuilder.writeByte((int)block.getByte(positionArray[i], 0)).closeEntry();
                }
            }
        }
    }

    public static class IntPositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeInt(block.getInt(position, 0)).closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    blockBuilder.writeInt(block.getInt(positionArray[i], 0)).closeEntry();
                }
            }
        }
    }

    public static class LongPositionsAppender
    implements PositionsAppender {
        @Override
        public void appendTo(IntArrayList positions, Block block, BlockBuilder blockBuilder) {
            int[] positionArray = positions.elements();
            if (block.mayHaveNull()) {
                for (int i = 0; i < positions.size(); ++i) {
                    int position = positionArray[i];
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
                }
            } else {
                for (int i = 0; i < positions.size(); ++i) {
                    blockBuilder.writeLong(block.getLong(positionArray[i], 0)).closeEntry();
                }
            }
        }
    }
}

