/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.sql.gen.lambda.LambdaFunctionInterface;
import java.util.function.Supplier;

@Description(value="Internal try function for desugaring TRY")
@ScalarFunction(value="$internal$try", hidden=true, deterministic=false)
public final class TryFunction {
    public static final String NAME = "$internal$try";

    private TryFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlNullable
    @SqlType(value="T")
    public static Long tryLong(@SqlType(value="function(T)") TryLongLambda function) {
        try {
            return function.apply();
        }
        catch (TrinoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlNullable
    @SqlType(value="T")
    public static Double tryDouble(@SqlType(value="function(T)") TryDoubleLambda function) {
        try {
            return function.apply();
        }
        catch (TrinoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlNullable
    @SqlType(value="T")
    public static Boolean tryBoolean(@SqlType(value="function(T)") TryBooleanLambda function) {
        try {
            return function.apply();
        }
        catch (TrinoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlNullable
    @SqlType(value="T")
    public static Object tryObject(@SqlType(value="function(T)") TryObjectLambda function) {
        try {
            return function.apply();
        }
        catch (TrinoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    public static <T> T evaluate(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (TrinoException e) {
            TryFunction.propagateIfUnhandled(e);
            return defaultValue;
        }
    }

    private static void propagateIfUnhandled(TrinoException e) throws TrinoException {
        int errorCode = e.getErrorCode().getCode();
        if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
            return;
        }
        throw e;
    }

    @FunctionalInterface
    public static interface TryObjectLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }

    @FunctionalInterface
    public static interface TryBooleanLambda
    extends LambdaFunctionInterface {
        public Boolean apply();
    }

    @FunctionalInterface
    public static interface TryDoubleLambda
    extends LambdaFunctionInterface {
        public Double apply();
    }

    @FunctionalInterface
    public static interface TryLongLambda
    extends LambdaFunctionInterface {
        public Long apply();
    }
}

