/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.Constraint;
import io.trino.type.DateTimes;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarFunction(value="to_iso8601")
public final class ToIso8601 {
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss");
    private static final String RESULT_LENGTH = "1 + 6 + 15 + min(p, 1) + p";

    private ToIso8601() {
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long epochMicros) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, epochMicros, 0, ZoneOffset.UTC, ISO8601_FORMATTER));
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), ZoneOffset.UTC, ISO8601_FORMATTER));
    }
}

