/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.client.ClientCapabilities;
import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.client.Column;
import io.trino.client.FailureInfo;
import io.trino.client.NamedClientTypeSignature;
import io.trino.client.ProtocolHeaders;
import io.trino.client.QueryError;
import io.trino.client.QueryResults;
import io.trino.client.RowFieldName;
import io.trino.client.StatementStats;
import io.trino.client.Warning;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageStats;
import io.trino.execution.TaskInfo;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.protocol.QueryInfoUrlFactory;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCode;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.ExpressionFormatter;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.IntervalDayTimeDataType;
import io.trino.sql.tree.NumericParameter;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.TypeParameter;
import io.trino.transaction.TransactionId;
import io.trino.util.Failures;
import io.trino.util.MoreLists;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private final QueryManager queryManager;
    private final QueryId queryId;
    private final Session session;
    private final Slug slug;
    private final Optional<URI> queryInfoUrl;
    @GuardedBy(value="this")
    private final DirectExchangeClient exchangeClient;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final PagesSerde serde;
    private final boolean supportsParametricDateTime;
    @GuardedBy(value="this")
    private OptionalLong nextToken = OptionalLong.of(0L);
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private long lastToken = -1L;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setSchema = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setPath = Optional.empty();
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties = ImmutableSet.of();
    @GuardedBy(value="this")
    private Map<String, SelectedRole> setRoles = ImmutableMap.of();
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements = ImmutableSet.of();
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId = Optional.empty();
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Optional<Throwable> typeSerializationException = Optional.empty();
    @GuardedBy(value="this")
    private Long updateCount;

    public static Query create(Session session, Slug slug, QueryManager queryManager, Optional<URI> queryInfoUrl, DirectExchangeClientSupplier directExchangeClientSupplier, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        DirectExchangeClient exchangeClient = directExchangeClientSupplier.get(session.getQueryId(), new ExchangeId("direct-exchange-query-results"), (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), Query.class.getSimpleName()), queryManager::outputTaskFailed, SystemSessionProperties.getRetryPolicy(session));
        Query result = new Query(session, slug, queryManager, queryInfoUrl, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
        result.queryManager.addOutputInfoListener(result.getQueryId(), result::setQueryOutputInfo);
        result.queryManager.addStateChangeListener(result.getQueryId(), state -> {
            if (state.isDone()) {
                QueryInfo queryInfo = queryManager.getFullQueryInfo(result.getQueryId());
                result.closeExchangeClientIfNecessary(queryInfo);
            }
        });
        return result;
    }

    private Query(Session session, Slug slug, QueryManager queryManager, Optional<URI> queryInfoUrl, DirectExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(slug, "slug is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(queryInfoUrl, "queryInfoUrl is null");
        Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.queryManager = queryManager;
        this.queryId = session.getQueryId();
        this.session = session;
        this.slug = slug;
        this.queryInfoUrl = queryInfoUrl;
        this.exchangeClient = exchangeClient;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        this.supportsParametricDateTime = session.getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        this.serde = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session)).createPagesSerde();
    }

    public void cancel() {
        this.queryManager.cancelQuery(this.queryId);
        this.dispose();
    }

    public void partialCancel(int id) {
        StageId stageId = new StageId(this.queryId, id);
        this.queryManager.cancelStage(stageId);
    }

    public void fail(Throwable throwable) {
        this.queryManager.failQuery(this.queryId, throwable);
    }

    public synchronized void dispose() {
        this.exchangeClient.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isSlugValid(String slug, long token) {
        return this.slug.isValid(Slug.Context.EXECUTING_QUERY, slug, token);
    }

    public QueryInfo getQueryInfo() {
        return this.queryManager.getFullQueryInfo(this.queryId);
    }

    public ProtocolHeaders getProtocolHeaders() {
        return this.session.getProtocolHeaders();
    }

    public synchronized Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    public synchronized Optional<String> getSetSchema() {
        return this.setSchema;
    }

    public synchronized Optional<String> getSetPath() {
        return this.setPath;
    }

    public synchronized Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public synchronized Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public synchronized Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    public synchronized Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public synchronized Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public synchronized Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    public synchronized boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    public synchronized ListenableFuture<QueryResults> waitForResults(long token, UriInfo uriInfo, Duration wait, DataSize targetResultSize) {
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return Futures.immediateFuture((Object)cachedResult.get());
        }
        ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo, targetResultSize), (Executor)this.resultsProcessorExecutor);
    }

    private synchronized ListenableFuture<Void> getFutureStateChange() {
        if (!this.exchangeClient.isFinished()) {
            return this.exchangeClient.isBlocked();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        try {
            return this.queryDoneFuture(this.queryManager.getQueryState(this.queryId));
        }
        catch (NoSuchElementException e) {
            return Futures.immediateVoidFuture();
        }
    }

    private synchronized Optional<QueryResults> getCachedResult(long token) {
        if (this.lastResult == null) {
            return Optional.empty();
        }
        if (token == this.lastToken) {
            this.queryManager.recordHeartbeat(this.queryId);
            return Optional.of(this.lastResult);
        }
        if (token < this.lastToken) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (this.nextToken.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (token != this.nextToken.getAsLong()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    private synchronized QueryResults getNextResult(long token, UriInfo uriInfo, DataSize targetResultSize) {
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return cachedResult.get();
        }
        Verify.verify((boolean)this.nextToken.isPresent(), (String)"Cannot generate next result when next token is not present", (Object[])new Object[0]);
        Verify.verify((token == this.nextToken.getAsLong() ? 1 : 0) != 0, (String)"Expected token to equal next token", (Object[])new Object[0]);
        QueryInfo queryInfo = this.queryManager.getFullQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        this.closeExchangeClientIfNecessary(queryInfo);
        QueryResultRows resultRows = this.removePagesFromExchange(queryInfo, targetResultSize.toBytes());
        if (queryInfo.getUpdateType() != null && this.updateCount == null) {
            Optional<Long> updatedRowsCount = resultRows.getUpdateCount();
            this.updateCount = updatedRowsCount.orElse(null);
        }
        if (queryInfo.getState() != QueryState.FAILED && (!queryInfo.isFinalQueryInfo() || !this.exchangeClient.isFinished() || this.lastResult != null && this.lastResult.getData() != null)) {
            this.nextToken = OptionalLong.of(token + 1L);
        } else {
            this.nextToken = OptionalLong.empty();
            this.exchangeClient.close();
        }
        URI nextResultsUri = null;
        URI partialCancelUri = null;
        if (this.nextToken.isPresent()) {
            long nextToken = this.nextToken.getAsLong();
            nextResultsUri = this.createNextResultsUri(uriInfo, nextToken);
            partialCancelUri = Query.findCancelableLeafStage(queryInfo).map(stage -> this.createPartialCancelUri((int)stage, uriInfo, nextToken)).orElse(null);
        }
        this.setCatalog = queryInfo.getSetCatalog();
        this.setSchema = queryInfo.getSetSchema();
        this.setPath = queryInfo.getSetPath();
        this.setSessionProperties = queryInfo.getSetSessionProperties();
        this.resetSessionProperties = queryInfo.getResetSessionProperties();
        this.setRoles = queryInfo.getSetRoles();
        this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.getStartedTransactionId();
        this.clearTransactionId = queryInfo.isClearTransactionId();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), QueryInfoUrlFactory.getQueryInfoUri(this.queryInfoUrl, this.queryId, uriInfo), partialCancelUri, nextResultsUri, (List)resultRows.getColumns().orElse(null), (Iterable)(resultRows.isEmpty() ? null : resultRows), Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo, this.typeSerializationException), MoreLists.mappedCopy(queryInfo.getWarnings(), Query::toClientWarning), queryInfo.getUpdateType(), this.updateCount);
        this.lastToken = token;
        this.lastResult = queryResults;
        return queryResults;
    }

    private synchronized QueryResultRows removePagesFromExchange(QueryInfo queryInfo, long targetResultBytes) {
        if (queryInfo.getState() == QueryState.FINISHED && queryInfo.getOutputStage().isEmpty()) {
            return QueryResultRows.queryResultRowsBuilder(this.session).withSingleBooleanValue(this.createColumn("result", (Type)BooleanType.BOOLEAN), true).build();
        }
        QueryResultRows.Builder resultBuilder = QueryResultRows.queryResultRowsBuilder(this.session).withExceptionConsumer(this::handleSerializationException).withColumnsAndTypes(this.columns, this.types);
        try (PagesSerde.PagesSerdeContext context = this.serde.newContext();){
            Slice serializedPage;
            Page page;
            for (long bytes = 0L; bytes < targetResultBytes && (serializedPage = this.exchangeClient.pollPage()) != null; bytes += page.getLogicalSizeInBytes()) {
                page = this.serde.deserialize(context, serializedPage);
                resultBuilder.addPage(page);
            }
            if (this.exchangeClient.isFinished()) {
                this.exchangeClient.close();
            }
        }
        catch (Throwable cause) {
            this.queryManager.failQuery(this.queryId, cause);
        }
        return resultBuilder.build();
    }

    private synchronized void closeExchangeClientIfNecessary(QueryInfo queryInfo) {
        if (queryInfo.getState() == QueryState.FAILED || queryInfo.getState().isDone() && queryInfo.getOutputStage().isEmpty()) {
            this.exchangeClient.close();
        }
    }

    private synchronized void handleSerializationException(Throwable exception) {
        try {
            this.queryManager.failQuery(this.queryId, exception);
        }
        catch (RuntimeException e) {
            log.debug((Throwable)e, "Could not fail query");
        }
        if (this.typeSerializationException.isEmpty()) {
            this.typeSerializationException = Optional.of(exception);
        }
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                list.add((Object)this.createColumn(columnNames.get(i), columnTypes.get(i)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        outputInfo.getBufferLocations().forEach(this.exchangeClient::addLocation);
        if (outputInfo.isNoMoreBufferLocations()) {
            this.exchangeClient.noMoreLocations();
        }
    }

    private ListenableFuture<Void> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateVoidFuture();
        }
        return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized URI createNextResultsUri(UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().replacePath("/v1/statement/executing").path(this.queryId.toString()).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private URI createPartialCancelUri(int stage, UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().replacePath("/v1/statement/executing/partialCancel").path(this.queryId.toString()).path(String.valueOf(stage)).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private Column createColumn(String name, Type type) {
        String formatted = this.formatType(TypeSignatureTranslator.toSqlType(type));
        return new Column(name, formatted, this.toClientTypeSignature(type.getTypeSignature()));
    }

    private String formatType(DataType type) {
        if (type instanceof DateTimeDataType) {
            DateTimeDataType dataTimeType = (DateTimeDataType)type;
            if (!this.supportsParametricDateTime) {
                if (dataTimeType.getType() == DateTimeDataType.Type.TIMESTAMP && dataTimeType.isWithTimeZone()) {
                    return "timestamp with time zone";
                }
                if (dataTimeType.getType() == DateTimeDataType.Type.TIMESTAMP && !dataTimeType.isWithTimeZone()) {
                    return "timestamp";
                }
                if (dataTimeType.getType() == DateTimeDataType.Type.TIME && !dataTimeType.isWithTimeZone()) {
                    return "time";
                }
                if (dataTimeType.getType() == DateTimeDataType.Type.TIME && dataTimeType.isWithTimeZone()) {
                    return "time with time zone";
                }
            }
            return ExpressionFormatter.formatExpression((Expression)type);
        }
        if (type instanceof RowDataType) {
            RowDataType rowDataType = (RowDataType)type;
            return rowDataType.getFields().stream().map(field -> field.getName().map(name -> name + " ").orElse("") + this.formatType(field.getType())).collect(Collectors.joining(", ", "row(", ")"));
        }
        if (type instanceof GenericDataType) {
            GenericDataType dataType = (GenericDataType)type;
            if (dataType.getArguments().isEmpty()) {
                return dataType.getName().getValue();
            }
            return dataType.getArguments().stream().map(parameter -> {
                if (parameter instanceof NumericParameter) {
                    return ((NumericParameter)parameter).getValue();
                }
                if (parameter instanceof TypeParameter) {
                    return this.formatType(((TypeParameter)parameter).getValue());
                }
                throw new IllegalArgumentException("Unsupported parameter type: " + parameter.getClass().getName());
            }).collect(Collectors.joining(", ", dataType.getName().getValue() + "(", ")"));
        }
        if (type instanceof IntervalDayTimeDataType) {
            return ExpressionFormatter.formatExpression((Expression)type);
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getClass().getName());
    }

    private ClientTypeSignature toClientTypeSignature(TypeSignature signature) {
        if (!this.supportsParametricDateTime) {
            if (signature.getBase().equalsIgnoreCase("timestamp")) {
                return new ClientTypeSignature("timestamp");
            }
            if (signature.getBase().equalsIgnoreCase("timestamp with time zone")) {
                return new ClientTypeSignature("timestamp with time zone");
            }
            if (signature.getBase().equalsIgnoreCase("time")) {
                return new ClientTypeSignature("time");
            }
            if (signature.getBase().equalsIgnoreCase("time with time zone")) {
                return new ClientTypeSignature("time with time zone");
            }
        }
        return new ClientTypeSignature(signature.getBase(), (List)signature.getParameters().stream().map(this::toClientTypeSignatureParameter).collect(ImmutableList.toImmutableList()));
    }

    private ClientTypeSignatureParameter toClientTypeSignatureParameter(TypeSignatureParameter parameter) {
        switch (parameter.getKind()) {
            case TYPE: {
                return ClientTypeSignatureParameter.ofType((ClientTypeSignature)this.toClientTypeSignature(parameter.getTypeSignature()));
            }
            case NAMED_TYPE: {
                return ClientTypeSignatureParameter.ofNamedType((NamedClientTypeSignature)new NamedClientTypeSignature(parameter.getNamedTypeSignature().getFieldName().map(value -> new RowFieldName(value.getName())), this.toClientTypeSignature(parameter.getNamedTypeSignature().getTypeSignature())));
            }
            case LONG: {
                return ClientTypeSignatureParameter.ofLong((long)parameter.getLongLiteral());
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + parameter.getKind());
    }

    private static StatementStats toStatementStats(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        StageInfo outputStage = queryInfo.getOutputStage().orElse(null);
        return StatementStats.builder().setState(queryInfo.getState().toString()).setQueued(queryInfo.getState() == QueryState.QUEUED).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(outputStage).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers() + queryStats.getBlockedDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setQueuedTimeMillis(queryStats.getQueuedTime().toMillis()).setElapsedTimeMillis(queryStats.getElapsedTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setPhysicalInputBytes(queryStats.getPhysicalInputDataSize().toBytes()).setPeakMemoryBytes(queryStats.getPeakUserMemoryReservation().toBytes()).setSpilledBytes(queryStats.getSpilledDataSize().toBytes()).setRootStage(Query.toStageStats(outputStage)).build();
    }

    private static io.trino.client.StageStats toStageStats(StageInfo stageInfo) {
        if (stageInfo == null) {
            return null;
        }
        StageStats stageStats = stageInfo.getStageStats();
        ImmutableList.Builder subStages = ImmutableList.builder();
        for (StageInfo subStage : stageInfo.getSubStages()) {
            subStages.add((Object)Query.toStageStats(subStage));
        }
        HashSet<CallSite> uniqueNodes = new HashSet<CallSite>();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            uniqueNodes.add((CallSite)((Object)(uri.getHost() + ":" + uri.getPort())));
        }
        return io.trino.client.StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(stageInfo.getState().toString()).setDone(stageInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageStats.getTotalDrivers()).setQueuedSplits(stageStats.getQueuedDrivers()).setRunningSplits(stageStats.getRunningDrivers() + stageStats.getBlockedDrivers()).setCompletedSplits(stageStats.getCompletedDrivers()).setCpuTimeMillis(stageStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageStats.getRawInputPositions()).setProcessedBytes(stageStats.getRawInputDataSize().toBytes()).setPhysicalInputBytes(stageStats.getPhysicalInputDataSize().toBytes()).setFailedTasks(stageStats.getFailedTasks()).setCoordinatorOnly(stageInfo.isCoordinatorOnly()).setSubStages((List)subStages.build()).build();
    }

    private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
        if (stageInfo == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        for (TaskInfo task : stageInfo.getTasks()) {
            URI uri = task.getTaskStatus().getSelf();
            nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
        }
        for (StageInfo subStage : stageInfo.getSubStages()) {
            nodes.addAll(Query.globalUniqueNodes(subStage));
        }
        return nodes.build();
    }

    private static Optional<Integer> findCancelableLeafStage(QueryInfo queryInfo) {
        return queryInfo.getOutputStage().flatMap(Query::findCancelableLeafStage);
    }

    private static Optional<Integer> findCancelableLeafStage(StageInfo stage) {
        if (stage.getState().isDone()) {
            return Optional.empty();
        }
        for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
            Optional<Integer> leafStage = Query.findCancelableLeafStage(subStage);
            if (!leafStage.isPresent()) continue;
            return leafStage;
        }
        return Optional.of(stage.getStageId().getId());
    }

    private static QueryError toQueryError(QueryInfo queryInfo, Optional<Throwable> exception) {
        ErrorCode errorCode;
        ExecutionFailureInfo executionFailure;
        QueryState state = queryInfo.getState();
        if (state != QueryState.FAILED && exception.isEmpty()) {
            return null;
        }
        if (queryInfo.getFailureInfo() != null) {
            executionFailure = queryInfo.getFailureInfo();
        } else if (exception.isPresent()) {
            executionFailure = Failures.toFailure(exception.get());
        } else {
            log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
            executionFailure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state})));
        }
        FailureInfo failure = executionFailure.toFailureInfo();
        if (queryInfo.getErrorCode() != null) {
            errorCode = queryInfo.getErrorCode();
        } else if (exception.isPresent()) {
            errorCode = StandardErrorCode.SERIALIZATION_ERROR.toErrorCode();
        } else {
            errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
            log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
        }
        return new QueryError((String)MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
    }

    private static Warning toClientWarning(TrinoWarning warning) {
        WarningCode code = warning.getWarningCode();
        return new Warning(new Warning.Code(code.getCode(), code.getName()), warning.getMessage());
    }
}

