/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.CertificateConfig;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.Identity;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class CertificateAuthenticator
implements Authenticator {
    private static final String X509_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private final CertificateAuthenticatorManager authenticatorManager;
    private final UserMapping userMapping;

    @Inject
    public CertificateAuthenticator(CertificateAuthenticatorManager authenticatorManager, CertificateConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
        authenticatorManager.setRequired();
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        Object attribute = request.getProperty(X509_ATTRIBUTE);
        if (attribute == null) {
            throw new AuthenticationException(null);
        }
        ImmutableList certificates = ImmutableList.copyOf((Object[])((X509Certificate[])attribute));
        if (certificates.isEmpty()) {
            throw new AuthenticationException(null);
        }
        try {
            Principal principal = this.authenticatorManager.getAuthenticator().authenticate((List)certificates);
            String authenticatedUser = this.userMapping.mapUser(principal.toString());
            return Identity.forUser((String)authenticatedUser).withPrincipal(principal).build();
        }
        catch (UserMappingException e) {
            throw new AuthenticationException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }
}

