/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class OAuth2Config {
    private Optional<String> stateKey = Optional.empty();
    private String issuer;
    private Optional<String> accessTokenIssuer = Optional.empty();
    private String authUrl;
    private String tokenUrl;
    private String jwksUrl;
    private Optional<String> userinfoUrl = Optional.empty();
    private String clientId;
    private String clientSecret;
    private Set<String> scopes = ImmutableSet.of((Object)"openid");
    private String principalField = "sub";
    private Optional<String> groupsField = Optional.empty();
    private List<String> additionalAudiences = Collections.emptyList();
    private Duration challengeTimeout = new Duration(15.0, TimeUnit.MINUTES);
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();

    public Optional<String> getStateKey() {
        return this.stateKey;
    }

    @Config(value="http-server.authentication.oauth2.state-key")
    @ConfigDescription(value="A secret key used by HMAC algorithm to sign the state parameter")
    public OAuth2Config setStateKey(String stateKey) {
        this.stateKey = Optional.ofNullable(stateKey);
        return this;
    }

    @NotNull
    public String getIssuer() {
        return this.issuer;
    }

    @Config(value="http-server.authentication.oauth2.issuer")
    @ConfigDescription(value="The required issuer of a token")
    public OAuth2Config setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @NotNull
    public Optional<String> getAccessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    @Config(value="http-server.authentication.oauth2.access-token-issuer")
    @ConfigDescription(value="The required issuer for access tokens")
    public OAuth2Config setAccessTokenIssuer(String accessTokenIssuer) {
        this.accessTokenIssuer = Optional.ofNullable(accessTokenIssuer);
        return this;
    }

    @NotNull
    public String getAuthUrl() {
        return this.authUrl;
    }

    @Config(value="http-server.authentication.oauth2.auth-url")
    @ConfigDescription(value="URL of the authorization server's authorization endpoint")
    public OAuth2Config setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
        return this;
    }

    @NotNull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Config(value="http-server.authentication.oauth2.token-url")
    @ConfigDescription(value="URL of the authorization server's token endpoint")
    public OAuth2Config setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    @NotNull
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @Config(value="http-server.authentication.oauth2.jwks-url")
    @ConfigDescription(value="URL of the authorization server's JWKS (JSON Web Key Set) endpoint")
    public OAuth2Config setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    public Optional<String> getUserinfoUrl() {
        return this.userinfoUrl;
    }

    @Config(value="http-server.authentication.oauth2.userinfo-url")
    @ConfigDescription(value="URL of the userinfo endpoint")
    public OAuth2Config setUserinfoUrl(String userinfoUrl) {
        this.userinfoUrl = Optional.ofNullable(userinfoUrl);
        return this;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Config(value="http-server.authentication.oauth2.client-id")
    @ConfigDescription(value="Client ID")
    public OAuth2Config setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @NotNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Config(value="http-server.authentication.oauth2.client-secret")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Client secret")
    public OAuth2Config setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @NotNull
    public List<String> getAdditionalAudiences() {
        return this.additionalAudiences;
    }

    @LegacyConfig(value={"http-server.authentication.oauth2.audience"})
    @Config(value="http-server.authentication.oauth2.additional-audiences")
    @ConfigDescription(value="Additional audiences to trust in addition to the Client ID")
    public OAuth2Config setAdditionalAudiences(List<String> additionalAudiences) {
        this.additionalAudiences = ImmutableList.copyOf(additionalAudiences);
        return this;
    }

    @NotNull
    public Set<String> getScopes() {
        return this.scopes;
    }

    @Config(value="http-server.authentication.oauth2.scopes")
    @ConfigDescription(value="Scopes requested by the server during OAuth2 authorization challenge")
    public OAuth2Config setScopes(String scopes) {
        this.scopes = (Set)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToStream((CharSequence)scopes).collect(ImmutableSet.toImmutableSet());
        return this;
    }

    @NotNull
    public String getPrincipalField() {
        return this.principalField;
    }

    @Config(value="http-server.authentication.oauth2.principal-field")
    @ConfigDescription(value="The claim to use as the principal")
    public OAuth2Config setPrincipalField(String principalField) {
        this.principalField = principalField;
        return this;
    }

    public Optional<String> getGroupsField() {
        return this.groupsField;
    }

    @Config(value="http-server.authentication.oauth2.groups-field")
    @ConfigDescription(value="Groups field in the claim")
    public OAuth2Config setGroupsField(String groupsField) {
        this.groupsField = Optional.ofNullable(groupsField);
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getChallengeTimeout() {
        return this.challengeTimeout;
    }

    @Config(value="http-server.authentication.oauth2.challenge-timeout")
    @ConfigDescription(value="Maximum duration of OAuth2 authorization challenge")
    public OAuth2Config setChallengeTimeout(Duration challengeTimeout) {
        this.challengeTimeout = challengeTimeout;
        return this;
    }

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.oauth2.user-mapping.pattern")
    @ConfigDescription(value="Regex to match against user name")
    public OAuth2Config setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<@FileExists File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="http-server.authentication.oauth2.user-mapping.file")
    @ConfigDescription(value="File containing rules for mapping user")
    public OAuth2Config setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }
}

