/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import io.trino.server.security.InsecureAuthenticatorConfig;
import io.trino.server.security.SecurityConfig;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.ui.FormAuthenticator;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class InsecureFormAuthenticator
implements FormAuthenticator {
    private final UserMapping userMapping;
    private final boolean insecureAuthenticationOverHttpAllowed;

    @Inject
    public InsecureFormAuthenticator(InsecureAuthenticatorConfig config, SecurityConfig securityConfig) {
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.insecureAuthenticationOverHttpAllowed = Objects.requireNonNull(securityConfig, "securityConfig is null").isInsecureAuthenticationOverHttpAllowed();
    }

    @Override
    public boolean isLoginEnabled(boolean secure) {
        return secure || this.insecureAuthenticationOverHttpAllowed;
    }

    @Override
    public boolean isPasswordAllowed(boolean secure) {
        return false;
    }

    @Override
    public Optional<String> isValidCredential(String username, String password, boolean secure) {
        if (username == null) {
            return Optional.empty();
        }
        if (this.isLoginEnabled(secure) && password == null) {
            try {
                return Optional.of(this.userMapping.mapUser(username));
            }
            catch (UserMappingException userMappingException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

