/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Optional;
import java.util.Set;

public class PruneIndexJoinColumns
extends ProjectOffPushDownRule<IndexJoinNode> {
    public PruneIndexJoinColumns() {
        super(Patterns.indexJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, IndexJoinNode indexJoinNode, Set<Symbol> referencedOutputs) {
        ImmutableSet.Builder probeInputs = ImmutableSet.builder().addAll(referencedOutputs).addAll((Iterable)indexJoinNode.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).collect(ImmutableList.toImmutableList()));
        indexJoinNode.getProbeHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)probeInputs).add(arg_0));
        ImmutableSet.Builder indexInputs = ImmutableSet.builder().addAll(referencedOutputs).addAll((Iterable)indexJoinNode.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableList.toImmutableList()));
        indexJoinNode.getIndexHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)indexInputs).add(arg_0));
        return Util.restrictChildOutputs(context.getIdAllocator(), indexJoinNode, new Set[]{probeInputs.build(), indexInputs.build()});
    }
}

