/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.util.MoreLists;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class PruneTableScanColumns
extends ProjectOffPushDownRule<TableScanNode> {
    private final Metadata metadata;

    public PruneTableScanColumns(Metadata metadata) {
        super(Patterns.tableScan());
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TableScanNode node, Set<Symbol> referencedOutputs) {
        Session session = context.getSession();
        TypeProvider types = context.getSymbolAllocator().getTypes();
        return PruneTableScanColumns.pruneColumns(this.metadata, types, session, node, referencedOutputs);
    }

    /*
     * Unable to fully structure code
     */
    public static Optional<PlanNode> pruneColumns(Metadata metadata, TypeProvider types, Session session, TableScanNode node, Set<Symbol> referencedOutputs) {
        newOutputs = MoreLists.filteredCopy(node.getOutputSymbols(), (Predicate<Symbol>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lio/trino/sql/planner/Symbol;)Z)(referencedOutputs));
        if (newOutputs.size() == node.getOutputSymbols().size()) {
            return Optional.empty();
        }
        projections = (List)newOutputs.stream().map((Function<Symbol, Variable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$pruneColumns$0(io.trino.sql.planner.TypeProvider io.trino.sql.planner.Symbol ), (Lio/trino/sql/planner/Symbol;)Lio/trino/spi/expression/Variable;)((TypeProvider)types)).collect(ImmutableList.toImmutableList());
        handle = node.getTable();
        result = metadata.applyProjection(session, handle, projections, (Map)newOutputs.stream().collect(ImmutableMap.toImmutableMap((Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lio/trino/sql/planner/Symbol;)Ljava/lang/String;)(), (Function<Symbol, ColumnHandle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lio/trino/sql/planner/Symbol;)Lio/trino/spi/connector/ColumnHandle;)(node.getAssignments()))));
        if (!result.isPresent()) ** GOTO lbl-1000
        if (result.get().getProjections().stream().allMatch((Predicate<ConnectorExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lio/trino/spi/expression/ConnectorExpression;)Z)(Variable.class))) {
            handle = (TableHandle)result.get().getHandle();
            assignments = (Map)result.get().getAssignments().stream().collect(ImmutableMap.toImmutableMap((Function<Assignment, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getVariable(), (Lio/trino/spi/connector/Assignment;)Ljava/lang/String;)(), (Function<Assignment, ColumnHandle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getColumn(), (Lio/trino/spi/connector/Assignment;)Lio/trino/spi/connector/ColumnHandle;)()));
            builder = ImmutableMap.builder();
            for (i = 0; i < newOutputs.size(); ++i) {
                variable = (Variable)result.get().getProjections().get(i);
                builder.put((Object)newOutputs.get(i), (Object)((ColumnHandle)assignments.get(variable.getName())));
            }
            newAssignments = builder.buildOrThrow();
        } else lbl-1000:
        // 2 sources

        {
            newAssignments = (Map)newOutputs.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), (Function<Symbol, ColumnHandle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lio/trino/sql/planner/Symbol;)Lio/trino/spi/connector/ColumnHandle;)(node.getAssignments())));
        }
        visibleColumns = ImmutableSet.copyOf(newAssignments.values());
        enforcedConstraint = node.getEnforcedConstraint().filter((BiPredicate<ColumnHandle, Domain>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$pruneColumns$1(java.util.Set io.trino.spi.connector.ColumnHandle io.trino.spi.predicate.Domain ), (Lio/trino/spi/connector/ColumnHandle;Lio/trino/spi/predicate/Domain;)Z)((Set)visibleColumns));
        newStatistics = node.getStatistics().map((Function<PlanNodeStatsEstimate, PlanNodeStatsEstimate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$pruneColumns$3(java.util.Map io.trino.cost.PlanNodeStatsEstimate ), (Lio/trino/cost/PlanNodeStatsEstimate;)Lio/trino/cost/PlanNodeStatsEstimate;)((Map)newAssignments));
        return Optional.of(new TableScanNode(node.getId(), handle, newOutputs, newAssignments, (TupleDomain<ColumnHandle>)enforcedConstraint, newStatistics, node.isUpdateTarget(), node.getUseConnectorNodePartitioning()));
    }

    private static /* synthetic */ PlanNodeStatsEstimate lambda$pruneColumns$3(Map newAssignments, PlanNodeStatsEstimate statistics) {
        return new PlanNodeStatsEstimate(statistics.getOutputRowCount(), (Map)statistics.getSymbolStatistics().entrySet().stream().filter(entry -> newAssignments.containsKey(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static /* synthetic */ boolean lambda$pruneColumns$1(Set visibleColumns, ColumnHandle columnHandle, Domain domain) {
        return visibleColumns.contains(columnHandle);
    }

    private static /* synthetic */ Variable lambda$pruneColumns$0(TypeProvider types, Symbol symbol) {
        return new Variable(symbol.getName(), types.get(symbol));
    }
}

