/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.StatsProvider;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.LayoutConstraintEvaluator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Rules;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class PushPredicateIntoTableScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public PushPredicateIntoTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Optional<PlanNode> rewritten = PushPredicateIntoTableScan.pushFilterIntoTableScan(filterNode, tableScan, false, context.getSession(), context.getSymbolAllocator(), this.plannerContext, this.typeAnalyzer, context.getStatsProvider(), new DomainTranslator(this.plannerContext));
        if (rewritten.isEmpty() || this.arePlansSame(filterNode, tableScan, rewritten.get())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewritten.get());
    }

    private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
        if (!(rewritten instanceof FilterNode)) {
            return false;
        }
        FilterNode rewrittenFilter = (FilterNode)rewritten;
        if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
            return false;
        }
        if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
            return false;
        }
        TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
        return Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint()) && Objects.equals(tableScan.getTable(), rewrittenTableScan.getTable());
    }

    public static Optional<PlanNode> pushFilterIntoTableScan(FilterNode filterNode, TableScanNode node, boolean pruneWithPredicateExpression, Session session, SymbolAllocator symbolAllocator, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, StatsProvider statsProvider, DomainTranslator domainTranslator) {
        Expression resultingPredicate;
        Expression remainingDecomposedPredicate;
        Constraint constraint;
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            return Optional.empty();
        }
        Expression predicate = filterNode.getPredicate();
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(plannerContext.getMetadata(), predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(plannerContext.getMetadata(), predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.getExtractionResult(plannerContext, session, deterministicPredicate, symbolAllocator.getTypes());
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transformKeys(node.getAssignments()::get).intersect(node.getEnforcedConstraint());
        Map<NodeRef<Expression>, Type> remainingExpressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), decomposedPredicate.getRemainingExpression());
        Optional connectorExpression = (Optional)new ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator(session, remainingExpressionTypes, plannerContext).process((Node)decomposedPredicate.getRemainingExpression());
        Map connectorExpressionAssignments = (Map)connectorExpression.map(ignored -> (ImmutableMap)node.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getValue))).orElse(ImmutableMap.of());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        if (pruneWithPredicateExpression && !BooleanLiteral.TRUE_LITERAL.equals((Object)decomposedPredicate.getRemainingExpression())) {
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = domainTranslator.toPredicate(session, (TupleDomain<Symbol>)newDomain.simplify().transformKeys(((Map)assignments)::get));
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(plannerContext, typeAnalyzer, session, symbolAllocator.getTypes(), node.getAssignments(), ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), expressionArray));
            constraint = new Constraint(newDomain, (ConnectorExpression)connectorExpression.orElse(Constant.TRUE), connectorExpressionAssignments, evaluator::isCandidate, evaluator.getArguments());
        } else {
            constraint = new Constraint(newDomain, (ConnectorExpression)connectorExpression.orElse(Constant.TRUE), connectorExpressionAssignments);
        }
        if (constraint.predicate().isEmpty() && newDomain.contains(node.getEnforcedConstraint())) {
            Expression resultingPredicate2 = PushPredicateIntoTableScan.createResultingPredicate(plannerContext, session, symbolAllocator, typeAnalyzer, (Expression)BooleanLiteral.TRUE_LITERAL, nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate2)) {
                return Optional.of(new FilterNode(filterNode.getId(), node, resultingPredicate2));
            }
            return Optional.of(node);
        }
        if (newDomain.isNone()) {
            return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        Optional<ConstraintApplicationResult<TableHandle>> result = plannerContext.getMetadata().applyFilter(session, node.getTable(), constraint);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        TableHandle newTable = (TableHandle)result.get().getHandle();
        TableProperties newTableProperties = plannerContext.getMetadata().getTableProperties(session, newTable);
        Optional<TableProperties.TablePartitioning> newTablePartitioning = newTableProperties.getTablePartitioning();
        if (newTableProperties.getPredicate().isNone()) {
            return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        TupleDomain remainingFilter = result.get().getRemainingFilter();
        Optional remainingConnectorExpression = result.get().getRemainingExpression();
        boolean precalculateStatistics = result.get().isPrecalculateStatistics();
        PushPredicateIntoTableScan.verifyTablePartitioning(session, plannerContext.getMetadata(), node, newTablePartitioning);
        TableScanNode tableScan = new TableScanNode(node.getId(), newTable, node.getOutputSymbols(), node.getAssignments(), PushPredicateIntoTableScan.computeEnforced((TupleDomain<ColumnHandle>)newDomain, (TupleDomain<ColumnHandle>)remainingFilter), Rules.deriveTableStatisticsForPushdown(statsProvider, session, precalculateStatistics, filterNode), node.isUpdateTarget(), node.getUseConnectorNodePartitioning());
        if (remainingConnectorExpression.isEmpty() || remainingConnectorExpression.equals(connectorExpression)) {
            remainingDecomposedPredicate = decomposedPredicate.getRemainingExpression();
        } else {
            Map variableMappings = (Map)assignments.values().stream().collect(ImmutableMap.toImmutableMap(Symbol::getName, Function.identity()));
            Expression translatedExpression = ConnectorExpressionTranslator.translate(session, (ConnectorExpression)remainingConnectorExpression.get(), plannerContext, variableMappings, new LiteralEncoder(plannerContext));
            remainingDecomposedPredicate = connectorExpression.isEmpty() ? ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), translatedExpression, decomposedPredicate.getRemainingExpression()) : translatedExpression;
        }
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)(resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(plannerContext, session, symbolAllocator, typeAnalyzer, domainTranslator.toPredicate(session, (TupleDomain<Symbol>)remainingFilter.transformKeys(((Map)assignments)::get)), nonDeterministicPredicate, remainingDecomposedPredicate)))) {
            return Optional.of(new FilterNode(filterNode.getId(), tableScan, resultingPredicate));
        }
        return Optional.of(tableScan);
    }

    private static void verifyTablePartitioning(Session session, Metadata metadata, TableScanNode oldTableScan, Optional<TableProperties.TablePartitioning> newTablePartitioning) {
        if (oldTableScan.getUseConnectorNodePartitioning().isEmpty()) {
            return;
        }
        Optional<TableProperties.TablePartitioning> oldTablePartitioning = metadata.getTableProperties(session, oldTableScan.getTable()).getTablePartitioning();
        Verify.verify((boolean)newTablePartitioning.equals(oldTablePartitioning), (String)"Partitioning must not change after predicate is pushed down", (Object[])new Object[0]);
    }

    static Expression createResultingPredicate(PlannerContext plannerContext, Session session, SymbolAllocator symbolAllocator, TypeAnalyzer typeAnalyzer, Expression unenforcedConstraints, Expression nonDeterministicPredicate, Expression remainingDecomposedPredicate) {
        Expression expression = ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), unenforcedConstraints, nonDeterministicPredicate, remainingDecomposedPredicate);
        expression = SimplifyExpressions.rewrite(expression, session, symbolAllocator, plannerContext, typeAnalyzer);
        return expression;
    }

    public static TupleDomain<ColumnHandle> computeEnforced(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced) {
        Preconditions.checkArgument((!unenforced.isNone() ? 1 : 0) != 0);
        Map predicateDomains = (Map)predicate.getDomains().get();
        Map unenforcedDomains = (Map)unenforced.getDomains().get();
        ImmutableMap.Builder enforcedDomainsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : predicateDomains.entrySet()) {
            ColumnHandle predicateColumnHandle = (ColumnHandle)entry.getKey();
            if (unenforcedDomains.containsKey(predicateColumnHandle)) {
                Preconditions.checkArgument((boolean)((Domain)entry.getValue()).equals(unenforcedDomains.get(predicateColumnHandle)), (Object)"Enforced tuple domain cannot be determined. The connector is expected to enforce the respective domain entirely on none, some, or all of the column.");
                continue;
            }
            enforcedDomainsBuilder.put((Object)predicateColumnHandle, (Object)((Domain)entry.getValue()));
        }
        ImmutableMap enforcedDomains = enforcedDomainsBuilder.buildOrThrow();
        Preconditions.checkArgument((enforcedDomains.size() + unenforcedDomains.size() == predicateDomains.size() ? 1 : 0) != 0, (Object)"Enforced tuple domain cannot be determined. Connector returned an unenforced TupleDomain that contains columns not in predicate.");
        return TupleDomain.withColumnDomains((Map)enforcedDomains);
    }
}

