/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;

public final class AllFunctionsResolved
implements PlanSanityChecker.Checker {
    private static final Visitor VISITOR = new Visitor();

    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        ExpressionExtractor.forEachExpression(planNode, AllFunctionsResolved::validate);
    }

    private static void validate(Expression expression) {
        VISITOR.process((Node)expression, null);
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private Visitor() {
        }

        protected Void visitFunctionCall(FunctionCall node, ImmutableList.Builder<Symbol> context) {
            Preconditions.checkArgument((boolean)ResolvedFunction.isResolved(node.getName()), (String)"Function call has not been resolved: %s", (Object)node);
            return super.visitFunctionCall(node, context);
        }
    }
}

