/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.ActualProperties;
import io.trino.sql.planner.optimizations.PropertyDerivations;
import io.trino.sql.planner.optimizations.StreamPropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.util.Optionals;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ValidateAggregationsWithDefaultValues
implements PlanSanityChecker.Checker {
    private final boolean forceSingleNode;

    public ValidateAggregationsWithDefaultValues(boolean forceSingleNode) {
        this.forceSingleNode = forceSingleNode;
    }

    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, plannerContext, typeAnalyzer, types), null);
    }

    private static class SeenExchanges {
        final boolean localRepartitionExchange;
        final boolean remoteRepartitionExchange;

        SeenExchanges(boolean localRepartitionExchange, boolean remoteRepartitionExchange) {
            this.localRepartitionExchange = localRepartitionExchange;
            this.remoteRepartitionExchange = remoteRepartitionExchange;
        }
    }

    private class Visitor
    extends PlanVisitor<Optional<SeenExchanges>, Void> {
        final Session session;
        final PlannerContext plannerContext;
        final TypeAnalyzer typeAnalyzer;
        final TypeProvider types;

        Visitor(Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        protected Optional<SeenExchanges> visitPlan(PlanNode node, Void context) {
            return this.aggregatedSeenExchanges(node.getSources());
        }

        @Override
        public Optional<SeenExchanges> visitAggregation(AggregationNode node, Void context) {
            Optional<SeenExchanges> seenExchangesOptional = this.aggregatedSeenExchanges(node.getSources());
            if (node.getStep() == AggregationNode.Step.PARTIAL) {
                return Optional.of(new SeenExchanges(false, false));
            }
            if (node.getStep() == AggregationNode.Step.INTERMEDIATE) {
                return seenExchangesOptional;
            }
            if (node.getStep() != AggregationNode.Step.FINAL || !node.hasEmptyGroupingSet()) {
                return Optional.empty();
            }
            Preconditions.checkState((boolean)seenExchangesOptional.isPresent(), (Object)"No partial aggregation below final aggregation");
            SeenExchanges seenExchanges = seenExchangesOptional.get();
            if (seenExchanges.remoteRepartitionExchange) {
                return Optional.empty();
            }
            ActualProperties globalProperties = PropertyDerivations.derivePropertiesRecursively(node, this.plannerContext, this.session, this.types, this.typeAnalyzer);
            Preconditions.checkArgument((ValidateAggregationsWithDefaultValues.this.forceSingleNode || globalProperties.isSingleNode() ? 1 : 0) != 0, (Object)"Final aggregation with default value not separated from partial aggregation by remote hash exchange");
            if (!seenExchanges.localRepartitionExchange) {
                StreamPropertyDerivations.StreamProperties localProperties = StreamPropertyDerivations.derivePropertiesRecursively(node, this.plannerContext, this.session, this.types, this.typeAnalyzer);
                Preconditions.checkArgument((boolean)localProperties.isSingleStream(), (Object)"Final aggregation with default value not separated from partial aggregation by local hash exchange");
            }
            return Optional.empty();
        }

        @Override
        public Optional<SeenExchanges> visitExchange(ExchangeNode node, Void context) {
            Optional<SeenExchanges> seenExchangesOptional = this.aggregatedSeenExchanges(node.getSources());
            if (seenExchangesOptional.isEmpty()) {
                return Optional.empty();
            }
            if (node.getType() != ExchangeNode.Type.REPARTITION) {
                return seenExchangesOptional;
            }
            SeenExchanges seenExchanges = seenExchangesOptional.get();
            if (node.getScope() == ExchangeNode.Scope.REMOTE) {
                return Optional.of(new SeenExchanges(false, true));
            }
            return Optional.of(new SeenExchanges(true, seenExchanges.remoteRepartitionExchange));
        }

        private Optional<SeenExchanges> aggregatedSeenExchanges(List<PlanNode> nodes) {
            return nodes.stream().map(source -> source.accept(this, null)).reduce((accumulatorOptional, seenExchangesOptional) -> Optionals.combine(accumulatorOptional, seenExchangesOptional, (accumulator, seenExchanges) -> new SeenExchanges(accumulator.localRepartitionExchange && seenExchanges.localRepartitionExchange, accumulator.remoteRepartitionExchange && seenExchanges.remoteRepartitionExchange))).orElse(Optional.empty());
        }
    }
}

