/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.ParsingUtil;
import io.trino.sql.QueryUtil;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.ArrayConstructor;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.Values;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class ShowQueriesRewrite
implements StatementRewrite.Rewrite {
    private final Metadata metadata;
    private final SqlParser parser;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;

    @Inject
    public ShowQueriesRewrite(Metadata metadata, SqlParser parser, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, ColumnPropertyManager columnPropertyManager, TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        Visitor visitor = new Visitor(this.metadata, this.parser, session, this.accessControl, this.sessionPropertyManager, this.schemaPropertyManager, this.columnPropertyManager, this.tablePropertyManager, this.materializedViewPropertyManager);
        return (Statement)visitor.process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final SqlParser sqlParser;
        private final AccessControl accessControl;
        private final SessionPropertyManager sessionPropertyManager;
        private final SchemaPropertyManager schemaPropertyManager;
        private final ColumnPropertyManager columnPropertyManager;
        private final TablePropertyManager tablePropertyManager;
        private final MaterializedViewPropertyManager materializedViewPropertyManager;

        public Visitor(Metadata metadata, SqlParser sqlParser, Session session, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, ColumnPropertyManager columnPropertyManager, TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
            this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
            this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
        }

        protected Node visitExplain(Explain node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), null);
            return new Explain(node.getLocation(), statement, node.getOptions());
        }

        protected Node visitExplainAnalyze(ExplainAnalyze node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), null);
            return new ExplainAnalyze(node.getLocation(), statement, node.isVerbose());
        }

        protected Node visitShowTables(ShowTables showTables, Void context) {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(this.session, (Node)showTables, showTables.getSchema());
            this.accessControl.checkCanShowTables(this.session.toSecurityContext(), schema);
            if (!this.metadata.catalogExists(this.session, schema.getCatalogName())) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)showTables, "Catalog '%s' does not exist", schema.getCatalogName());
            }
            if (!this.metadata.schemaExists(this.session, schema)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)showTables, "Schema '%s' does not exist", schema.getSchemaName());
            }
            Expression predicate = QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(schema.getSchemaName()));
            Optional likePattern = showTables.getLikePattern();
            if (likePattern.isPresent()) {
                LikePredicate likePredicate = new LikePredicate((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral((String)likePattern.get()), showTables.getEscape().map(StringLiteral::new));
                predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"table_name", (String)"Table")}), (Relation)Visitor.from(schema.getCatalogName(), InformationSchemaTable.TABLES.getSchemaTableName()), (Expression)predicate, (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"table_name")}));
        }

        protected Node visitShowGrants(ShowGrants showGrants, Void context) {
            String catalogName = this.session.getCatalog().orElse(null);
            Optional<Object> predicate = Optional.empty();
            Optional tableName = showGrants.getTableName();
            if (tableName.isPresent()) {
                QualifiedObjectName qualifiedTableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showGrants, (QualifiedName)tableName.get());
                if (!this.metadata.isView(this.session, qualifiedTableName)) {
                    RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(this.session, qualifiedTableName);
                    Optional<TableHandle> tableHandle = redirection.getTableHandle();
                    if (tableHandle.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)showGrants, "Table '%s' does not exist", tableName);
                    }
                    if (redirection.getRedirectedTableName().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)showGrants, "Table %s is redirected to %s and SHOW GRANTS is not supported with table redirections", tableName.get(), redirection.getRedirectedTableName().get());
                    }
                }
                catalogName = qualifiedTableName.getCatalogName();
                this.accessControl.checkCanShowTables(this.session.toSecurityContext(), new CatalogSchemaName(catalogName, qualifiedTableName.getSchemaName()));
                predicate = Optional.of(ExpressionUtils.combineConjuncts(this.metadata, QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(qualifiedTableName.getSchemaName())), QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral(qualifiedTableName.getObjectName()))));
            } else {
                if (catalogName == null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)showGrants, "Catalog must be specified when session catalog is not set", new Object[0]);
                }
                SortedSet<String> allowedSchemas = MetadataListing.listSchemas(this.session, this.metadata, this.accessControl, catalogName);
                for (String schema : allowedSchemas) {
                    this.accessControl.checkCanShowTables(this.session.toSecurityContext(), new CatalogSchemaName(catalogName, schema));
                }
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"grantor", (String)"Grantor"), QueryUtil.aliasedName((String)"grantor_type", (String)"Grantor Type"), QueryUtil.aliasedName((String)"grantee", (String)"Grantee"), QueryUtil.aliasedName((String)"grantee_type", (String)"Grantee Type"), QueryUtil.aliasedName((String)"table_catalog", (String)"Catalog"), QueryUtil.aliasedName((String)"table_schema", (String)"Schema"), QueryUtil.aliasedName((String)"table_name", (String)"Table"), QueryUtil.aliasedName((String)"privilege_type", (String)"Privilege"), QueryUtil.aliasedName((String)"is_grantable", (String)"Grantable"), QueryUtil.aliasedName((String)"with_hierarchy", (String)"With Hierarchy")}), (Relation)Visitor.from(catalogName, InformationSchemaTable.TABLE_PRIVILEGES.getSchemaTableName()), predicate, Optional.empty());
        }

        protected Node visitShowRoles(ShowRoles node, Void context) {
            Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, this.session, (Node)node, node.getCatalog().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)));
            if (node.isCurrent()) {
                this.accessControl.checkCanShowCurrentRoles(this.session.toSecurityContext(), catalog);
                Set enabledRoles = catalog.map(c -> this.metadata.listEnabledRoles(this.session, (String)c)).orElseGet(() -> this.session.getIdentity().getEnabledRoles());
                List<Expression> rows = enabledRoles.stream().map(role -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(role)})).collect(Collectors.toList());
                return Visitor.singleColumnValues(rows, "Role");
            }
            this.accessControl.checkCanShowRoles(this.session.toSecurityContext(), catalog);
            List<Expression> rows = this.metadata.listRoles(this.session, catalog).stream().map(role -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(role)})).collect(Collectors.toList());
            return Visitor.singleColumnValues(rows, "Role");
        }

        protected Node visitShowRoleGrants(ShowRoleGrants node, Void context) {
            Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, this.session, (Node)node, node.getCatalog().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)));
            TrinoPrincipal principal = new TrinoPrincipal(PrincipalType.USER, this.session.getUser());
            this.accessControl.checkCanShowRoleGrants(this.session.toSecurityContext(), catalog);
            List<Expression> rows = this.metadata.listRoleGrants(this.session, catalog, principal).stream().map(roleGrant -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(roleGrant.getRoleName())})).collect(Collectors.toList());
            return Visitor.singleColumnValues(rows, "Role Grants");
        }

        private static Query singleColumnValues(List<Expression> rows, String columnName) {
            ImmutableList columns = ImmutableList.of((Object)columnName);
            if (rows.isEmpty()) {
                return QueryUtil.emptyQuery((List)columns);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"relation", (List)columns), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)columnName)}));
        }

        protected Node visitShowSchemas(ShowSchemas node, Void context) {
            if (node.getCatalog().isEmpty() && this.session.getCatalog().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            String catalog = node.getCatalog().map(Identifier::getValue).orElseGet(() -> this.session.getCatalog().orElseThrow());
            this.accessControl.checkCanShowSchemas(this.session.toSecurityContext(), catalog);
            Optional<Object> predicate = Optional.empty();
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = Optional.of(new LikePredicate((Expression)QueryUtil.identifier((String)"schema_name"), (Expression)new StringLiteral((String)likePattern.get()), node.getEscape().map(StringLiteral::new)));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"schema_name", (String)"Schema")}), (Relation)Visitor.from(catalog, InformationSchemaTable.SCHEMATA.getSchemaTableName()), predicate, Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"schema_name")})));
        }

        protected Node visitShowCatalogs(ShowCatalogs node, Void context) {
            List rows = (List)MetadataListing.listCatalogs(this.session, this.metadata, this.accessControl).keySet().stream().map(name -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(name)})).collect(ImmutableList.toImmutableList());
            Optional<Object> predicate = Optional.empty();
            if (rows.isEmpty()) {
                rows = ImmutableList.of((Object)new StringLiteral(""));
                predicate = Optional.of(BooleanLiteral.FALSE_LITERAL);
            } else if (node.getLikePattern().isPresent()) {
                predicate = Optional.of(new LikePredicate((Expression)QueryUtil.identifier((String)"catalog"), (Expression)new StringLiteral((String)node.getLikePattern().get()), node.getEscape().map(StringLiteral::new)));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"catalogs", (List)ImmutableList.of((Object)"Catalog")), predicate, Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Catalog")})));
        }

        protected Node visitShowColumns(ShowColumns showColumns, Void context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showColumns, showColumns.getTable());
            MetadataUtil.getRequiredCatalogHandle(this.metadata, this.session, (Node)showColumns, tableName.getCatalogName());
            if (!this.metadata.schemaExists(this.session, new CatalogSchemaName(tableName.getCatalogName(), tableName.getSchemaName()))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)showColumns, "Schema '%s' does not exist", tableName.getSchemaName());
            }
            boolean isMaterializedView = this.metadata.isMaterializedView(this.session, tableName);
            boolean isView = false;
            QualifiedObjectName targetTableName = tableName;
            Optional<Object> tableHandle = Optional.empty();
            if (!isMaterializedView && !(isView = this.metadata.isView(this.session, tableName))) {
                RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(this.session, tableName);
                tableHandle = redirection.getTableHandle();
                if (tableHandle.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)showColumns, "Table '%s' does not exist", tableName);
                }
                targetTableName = redirection.getRedirectedTableName().orElse(tableName);
            }
            if (!isMaterializedView && !isView) {
                this.metadata.getTableMetadata(this.session, (TableHandle)tableHandle.get());
            }
            this.accessControl.checkCanShowColumns(this.session.toSecurityContext(), targetTableName.asCatalogSchemaTableName());
            Expression predicate = QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(targetTableName.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral(targetTableName.getObjectName())));
            Optional likePattern = showColumns.getLikePattern();
            if (likePattern.isPresent()) {
                LikePredicate likePredicate = new LikePredicate((Expression)QueryUtil.identifier((String)"column_name"), (Expression)new StringLiteral((String)likePattern.get()), showColumns.getEscape().map(StringLiteral::new));
                predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"column_name", (String)"Column"), QueryUtil.aliasedName((String)"data_type", (String)"Type"), QueryUtil.aliasedNullToEmpty((String)"extra_info", (String)"Extra"), QueryUtil.aliasedNullToEmpty((String)"comment", (String)"Comment")}), (Relation)Visitor.from(targetTableName.getCatalogName(), InformationSchemaTable.COLUMNS.getSchemaTableName()), (Expression)predicate, (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"ordinal_position")}));
        }

        private static <T> Expression getExpression(PropertyMetadata<T> property, Object value) throws TrinoException {
            return Visitor.toExpression(property.encode(property.getJavaType().cast(value)));
        }

        private static Expression toExpression(Object value) throws TrinoException {
            if (value instanceof String) {
                return new StringLiteral(value.toString());
            }
            if (value instanceof Boolean) {
                return new BooleanLiteral(value.toString());
            }
            if (value instanceof Long || value instanceof Integer) {
                return new LongLiteral(value.toString());
            }
            if (value instanceof Double) {
                return new DoubleLiteral(value.toString());
            }
            if (value instanceof List) {
                List list = (List)value;
                return new ArrayConstructor(list.stream().map(Visitor::toExpression).collect(Collectors.toList()));
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Failed to convert object of type %s to expression: %s", value.getClass().getName(), value));
        }

        protected Node visitShowCreate(ShowCreate node, Void context) {
            if (node.getType() == ShowCreate.Type.MATERIALIZED_VIEW) {
                QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
                Optional<MaterializedViewDefinition> viewDefinition = this.metadata.getMaterializedView(this.session, objectName);
                if (viewDefinition.isEmpty()) {
                    if (this.metadata.isView(this.session, objectName)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a view, not a materialized view", objectName);
                    }
                    if (this.metadata.getTableHandle(this.session, objectName).isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a table, not a materialized view", objectName);
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "Materialized view '%s' does not exist", objectName);
                }
                Query query = this.parseView(viewDefinition.get().getOriginalSql(), objectName, (Node)node);
                List parts = Lists.reverse((List)node.getName().getOriginalParts());
                Identifier tableName = (Identifier)parts.get(0);
                Identifier schemaName = parts.size() > 1 ? (Identifier)parts.get(1) : new Identifier(objectName.getSchemaName());
                Identifier catalogName = parts.size() > 2 ? (Identifier)parts.get(2) : new Identifier(objectName.getCatalogName());
                this.accessControl.checkCanShowCreateTable(this.session.toSecurityContext(), new QualifiedObjectName(catalogName.getValue(), schemaName.getValue(), tableName.getValue()));
                Map<String, Object> properties = viewDefinition.get().getProperties();
                Collection allMaterializedViewProperties = this.materializedViewPropertyManager.getAllProperties(new CatalogName(catalogName.getValue()));
                List<Property> propertyNodes = Visitor.buildProperties(objectName, Optional.empty(), StandardErrorCode.INVALID_MATERIALIZED_VIEW_PROPERTY, properties, allMaterializedViewProperties);
                String sql = SqlFormatter.formatSql((Node)new CreateMaterializedView(Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)tableName)), query, false, false, propertyNodes, viewDefinition.get().getComment())).trim();
                return QueryUtil.singleValueQuery((String)"Create Materialized View", (String)sql);
            }
            if (node.getType() == ShowCreate.Type.VIEW) {
                QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
                if (this.metadata.isMaterializedView(this.session, objectName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a materialized view, not a view", objectName);
                }
                Optional<ViewDefinition> viewDefinition = this.metadata.getView(this.session, objectName);
                if (viewDefinition.isEmpty()) {
                    if (this.metadata.getTableHandle(this.session, objectName).isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a table, not a view", objectName);
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "View '%s' does not exist", objectName);
                }
                Query query = this.parseView(viewDefinition.get().getOriginalSql(), objectName, (Node)node);
                List parts = Lists.reverse((List)node.getName().getOriginalParts());
                Identifier tableName = (Identifier)parts.get(0);
                Identifier schemaName = parts.size() > 1 ? (Identifier)parts.get(1) : new Identifier(objectName.getSchemaName());
                Identifier catalogName = parts.size() > 2 ? (Identifier)parts.get(2) : new Identifier(objectName.getCatalogName());
                this.accessControl.checkCanShowCreateTable(this.session.toSecurityContext(), new QualifiedObjectName(catalogName.getValue(), schemaName.getValue(), tableName.getValue()));
                CreateView.Security security = viewDefinition.get().isRunAsInvoker() ? CreateView.Security.INVOKER : CreateView.Security.DEFINER;
                String sql = SqlFormatter.formatSql((Node)new CreateView(QualifiedName.of((Iterable)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)tableName)), query, false, viewDefinition.get().getComment(), Optional.of(security))).trim();
                return QueryUtil.singleValueQuery((String)"Create View", (String)sql);
            }
            if (node.getType() == ShowCreate.Type.TABLE) {
                QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
                if (this.metadata.isMaterializedView(this.session, objectName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a materialized view, not a table", objectName);
                }
                if (this.metadata.isView(this.session, objectName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a view, not a table", objectName);
                }
                RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(this.session, objectName);
                Optional<TableHandle> tableHandle = redirection.getTableHandle();
                if (tableHandle.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)node, "Table '%s' does not exist", objectName);
                }
                QualifiedObjectName targetTableName = redirection.getRedirectedTableName().orElse(objectName);
                this.accessControl.checkCanShowCreateTable(this.session.toSecurityContext(), targetTableName);
                ConnectorTableMetadata connectorTableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get()).getMetadata();
                Collection allColumnProperties = this.columnPropertyManager.getAllProperties(tableHandle.get().getCatalogName());
                List columns = (List)connectorTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(column -> {
                    List<Property> propertyNodes = Visitor.buildProperties(targetTableName, Optional.of(column.getName()), StandardErrorCode.INVALID_COLUMN_PROPERTY, column.getProperties(), allColumnProperties);
                    return new ColumnDefinition(new Identifier(column.getName()), TypeSignatureTranslator.toSqlType(column.getType()), column.isNullable(), propertyNodes, Optional.ofNullable(column.getComment()));
                }).collect(ImmutableList.toImmutableList());
                Map properties = connectorTableMetadata.getProperties();
                Collection allTableProperties = this.tablePropertyManager.getAllProperties(tableHandle.get().getCatalogName());
                List<Property> propertyNodes = Visitor.buildProperties(targetTableName, Optional.empty(), StandardErrorCode.INVALID_TABLE_PROPERTY, properties, allTableProperties);
                CreateTable createTable = new CreateTable(QualifiedName.of((String)objectName.getCatalogName(), (String[])new String[]{objectName.getSchemaName(), objectName.getObjectName()}), columns, false, propertyNodes, connectorTableMetadata.getComment());
                return QueryUtil.singleValueQuery((String)"Create Table", (String)SqlFormatter.formatSql((Node)createTable).trim());
            }
            if (node.getType() == ShowCreate.Type.SCHEMA) {
                CatalogSchemaName schemaName = MetadataUtil.createCatalogSchemaName(this.session, (Node)node, Optional.of(node.getName()));
                if (!this.metadata.schemaExists(this.session, schemaName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)node, "Schema '%s' does not exist", schemaName);
                }
                this.accessControl.checkCanShowCreateSchema(this.session.toSecurityContext(), schemaName);
                Map<String, Object> properties = this.metadata.getSchemaProperties(this.session, schemaName);
                Collection allTableProperties = this.schemaPropertyManager.getAllProperties(new CatalogName(schemaName.getCatalogName()));
                QualifiedName qualifiedSchemaName = QualifiedName.of((String)schemaName.getCatalogName(), (String[])new String[]{schemaName.getSchemaName()});
                List<Property> propertyNodes = Visitor.buildProperties(qualifiedSchemaName, Optional.empty(), StandardErrorCode.INVALID_SCHEMA_PROPERTY, properties, allTableProperties);
                Optional<PrincipalSpecification> owner = this.metadata.getSchemaOwner(this.session, schemaName).map(MetadataUtil::createPrincipal);
                CreateSchema createSchema = new CreateSchema(qualifiedSchemaName, false, propertyNodes, owner);
                return QueryUtil.singleValueQuery((String)"Create Schema", (String)SqlFormatter.formatSql((Node)createSchema).trim());
            }
            throw new UnsupportedOperationException("SHOW CREATE only supported for schemas, tables and views");
        }

        private static List<Property> buildProperties(Object objectName, Optional<String> columnName, StandardErrorCode errorCode, Map<String, Object> properties, Collection<PropertyMetadata<?>> allProperties) {
            if (properties.isEmpty()) {
                return Collections.emptyList();
            }
            ImmutableMap indexedPropertyMetadata = Maps.uniqueIndex(allProperties, PropertyMetadata::getName);
            ImmutableSortedMap.Builder sqlProperties = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                String propertyName = propertyEntry.getKey();
                Object value = propertyEntry.getValue();
                if (value == null) {
                    throw new TrinoException((ErrorCodeSupplier)errorCode, String.format("Property %s for %s cannot have a null value", propertyName, Visitor.toQualifiedName(objectName, columnName)));
                }
                PropertyMetadata property = (PropertyMetadata)indexedPropertyMetadata.get(propertyName);
                if (property == null) {
                    throw new TrinoException((ErrorCodeSupplier)errorCode, "No PropertyMetadata for property: " + propertyName);
                }
                if (!Primitives.wrap((Class)property.getJavaType()).isInstance(value)) {
                    throw new TrinoException((ErrorCodeSupplier)errorCode, String.format("Property %s for %s should have value of type %s, not %s", propertyName, Visitor.toQualifiedName(objectName, columnName), property.getJavaType().getName(), value.getClass().getName()));
                }
                Expression sqlExpression = Visitor.getExpression(property, value);
                sqlProperties.put((Object)propertyName, (Object)sqlExpression);
            }
            return (List)sqlProperties.build().entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList());
        }

        private static String toQualifiedName(Object objectName, Optional<String> columnName) {
            return columnName.map(s -> String.format("column %s of table %s", s, objectName)).orElseGet(() -> "table " + objectName);
        }

        protected Node visitShowFunctions(ShowFunctions node, Void context) {
            List rows = (List)this.metadata.listFunctions().stream().filter(function -> !function.isHidden()).map(function -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(function.getSignature().getName()), new StringLiteral(function.getSignature().getReturnType().toString()), new StringLiteral(Joiner.on((String)", ").join(function.getSignature().getArgumentTypes())), new StringLiteral(Visitor.getFunctionType(function)), function.isDeterministic() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, new StringLiteral(Strings.nullToEmpty((String)function.getDescription()))})).collect(ImmutableList.toImmutableList());
            ImmutableMap columns = ImmutableMap.builder().put((Object)"function_name", (Object)"Function").put((Object)"return_type", (Object)"Return Type").put((Object)"argument_types", (Object)"Argument Types").put((Object)"function_type", (Object)"Function Type").put((Object)"deterministic", (Object)"Deterministic").put((Object)"description", (Object)"Description").buildOrThrow();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)((List)columns.entrySet().stream().map(entry -> QueryUtil.aliasedName((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableList.toImmutableList()))), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"functions", (List)ImmutableList.copyOf(columns.keySet())), (Expression)node.getLikePattern().map(like -> new LikePredicate((Expression)QueryUtil.identifier((String)"function_name"), (Expression)new StringLiteral(like), node.getEscape().map(StringLiteral::new))).map(Expression.class::cast).orElse((Expression)BooleanLiteral.TRUE_LITERAL), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{new SortItem(QueryUtil.functionCall((String)"lower", (Expression[])new Expression[]{QueryUtil.identifier((String)"function_name")}), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED), QueryUtil.ascending((String)"return_type"), QueryUtil.ascending((String)"argument_types"), QueryUtil.ascending((String)"function_type")}));
        }

        private static String getFunctionType(FunctionMetadata function) {
            FunctionKind kind = function.getKind();
            switch (kind) {
                case AGGREGATE: {
                    return "aggregate";
                }
                case WINDOW: {
                    return "window";
                }
                case SCALAR: {
                    return "scalar";
                }
            }
            throw new IllegalArgumentException("Unsupported function kind: " + kind);
        }

        protected Node visitShowSession(ShowSession node, Void context) {
            ImmutableList.Builder rows = ImmutableList.builder();
            SortedMap<String, CatalogName> catalogNames = MetadataListing.listCatalogs(this.session, this.metadata, this.accessControl);
            List<SessionPropertyManager.SessionPropertyValue> sessionProperties = this.sessionPropertyManager.getAllSessionProperties(this.session, catalogNames);
            for (SessionPropertyManager.SessionPropertyValue sessionProperty : sessionProperties) {
                if (sessionProperty.isHidden()) continue;
                String value = sessionProperty.getValue();
                String defaultValue = sessionProperty.getDefaultValue();
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(sessionProperty.getFullyQualifiedName()), new StringLiteral(Strings.nullToEmpty((String)value)), new StringLiteral(Strings.nullToEmpty((String)defaultValue)), new StringLiteral(sessionProperty.getType()), new StringLiteral(sessionProperty.getDescription()), BooleanLiteral.TRUE_LITERAL}));
            }
            rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), BooleanLiteral.FALSE_LITERAL}));
            Identifier predicate = QueryUtil.identifier((String)"include");
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = LogicalExpression.and((Expression)predicate, (Expression)new LikePredicate((Expression)QueryUtil.identifier((String)"name"), (Expression)new StringLiteral((String)likePattern.get()), node.getEscape().map(StringLiteral::new)));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"name", (String)"Name"), QueryUtil.aliasedName((String)"value", (String)"Value"), QueryUtil.aliasedName((String)"default", (String)"Default"), QueryUtil.aliasedName((String)"type", (String)"Type"), QueryUtil.aliasedName((String)"description", (String)"Description")}), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"session", (List)ImmutableList.of((Object)"name", (Object)"value", (Object)"default", (Object)"type", (Object)"description", (Object)"include")), (Expression)predicate);
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                Statement statement = this.sqlParser.createStatement(view, ParsingUtil.createParsingOptions(this.session));
                return (Query)statement;
            }
            catch (ParsingException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, node, e, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private static Relation from(String catalog, SchemaTableName table) {
            return QueryUtil.table((QualifiedName)QualifiedName.of((String)catalog, (String[])new String[]{table.getSchemaName(), table.getTableName()}));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

