/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.connector.CatalogName;
import io.trino.connector.ConnectorManager;
import io.trino.connector.system.AnalyzePropertiesSystemTable;
import io.trino.connector.system.CatalogSystemTable;
import io.trino.connector.system.ColumnPropertiesSystemTable;
import io.trino.connector.system.GlobalSystemConnectorFactory;
import io.trino.connector.system.MaterializedViewPropertiesSystemTable;
import io.trino.connector.system.MaterializedViewSystemTable;
import io.trino.connector.system.NodeSystemTable;
import io.trino.connector.system.SchemaPropertiesSystemTable;
import io.trino.connector.system.TableCommentSystemTable;
import io.trino.connector.system.TablePropertiesSystemTable;
import io.trino.connector.system.TransactionsSystemTable;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostComparator;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsCalculatorModule;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.TaskCountEstimator;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.FailureInjector;
import io.trino.execution.Lifespan;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.resourcegroups.NoOpResourceGroupManager;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.execution.warnings.WarningCollector;
import io.trino.index.IndexManager;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.ExchangeHandleResolver;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.ProcedureRegistry;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.Split;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OutputFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.operator.StageExecutionDescriptor;
import io.trino.operator.TaskContext;
import io.trino.operator.TrinoOperatorFactories;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.security.GroupProviderManager;
import io.trino.server.PluginManager;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.GenericPartitioningSpillerFactory;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.NodeSpillConfig;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.spiller.SpillerStats;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.split.SplitSource;
import io.trino.sql.ParameterUtils;
import io.trino.sql.ParsingUtil;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.rewrite.DescribeInputRewrite;
import io.trino.sql.rewrite.DescribeOutputRewrite;
import io.trino.sql.rewrite.ExplainRewrite;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.ShowStatsRewrite;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.Node;
import io.trino.testing.MaterializedResult;
import io.trino.testing.PageConsumerOperator;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingTaskContext;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.util.FinalizerService;
import io.trino.version.EmbedVersion;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class LocalQueryRunner
implements QueryRunner {
    private final EventListenerManager eventListenerManager = new EventListenerManager(new EventListenerConfig());
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final PlanFragmenter planFragmenter;
    private final InMemoryNodeManager nodeManager;
    private final BlockTypeOperators blockTypeOperators;
    private final PlannerContext plannerContext;
    private final StatsCalculator statsCalculator;
    private final ScalarStatsCalculator scalarStatsCalculator;
    private final CostCalculator costCalculator;
    private final CostCalculator estimatedExchangesCostCalculator;
    private final TaskCountEstimator taskCountEstimator;
    private final TestingGroupProvider groupProvider;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final CatalogManager catalogManager;
    private final TransactionManager transactionManager;
    private final FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private final SpillerFactory spillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final JoinCompiler joinCompiler;
    private final ConnectorManager connectorManager;
    private final PluginManager pluginManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final TaskManagerConfig taskManagerConfig;
    private final boolean alwaysRevokeMemory;
    private final NodeSpillConfig nodeSpillConfig;
    private final OptimizerConfig optimizerConfig;
    private final PlanOptimizersProvider planOptimizersProvider;
    private final OperatorFactories operatorFactories;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private boolean printPlan;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static LocalQueryRunner create(Session defaultSession) {
        return LocalQueryRunner.builder(defaultSession).build();
    }

    public static Builder builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, int nodeCountForStats, Map<String, List<PropertyMetadata<?>>> defaultSessionProperties, PlanOptimizersProvider planOptimizersProvider, OperatorFactories operatorFactories, Set<SystemSessionPropertiesProvider> extraSessionProperties) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Objects.requireNonNull(defaultSessionProperties, "defaultSessionProperties is null");
        Preconditions.checkArgument((defaultSession.getTransactionId().isEmpty() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        this.taskManagerConfig = new TaskManagerConfig().setTaskConcurrency(4);
        this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.planOptimizersProvider = Objects.requireNonNull(planOptimizersProvider, "planOptimizersProvider is null");
        this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
        this.alwaysRevokeMemory = alwaysRevokeMemory;
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        TypeOperators typeOperators = new TypeOperators();
        this.blockTypeOperators = new BlockTypeOperators(typeOperators);
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager();
        PagesIndexPageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
        this.indexManager = new IndexManager();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(true);
        NodeScheduler nodeScheduler = new NodeScheduler(new UniformNodeSelectorFactory(this.nodeManager, nodeSchedulerConfig, new NodeTaskMap(this.finalizerService)));
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.optimizerConfig = new OptimizerConfig();
        this.pageSinkManager = new PageSinkManager();
        this.catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, this.catalogManager, this.notificationExecutor);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler, this.blockTypeOperators);
        BlockEncodingManager blockEncodingManager = new BlockEncodingManager();
        TypeRegistry typeRegistry = new TypeRegistry(typeOperators, featuresConfig);
        InternalTypeManager typeManager = new InternalTypeManager(typeRegistry);
        InternalBlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(blockEncodingManager, typeManager);
        MetadataManager metadata = new MetadataManager(featuresConfig, new DisabledSystemSecurityMetadata(), this.transactionManager, typeOperators, this.blockTypeOperators, typeManager, blockEncodingSerde, this.nodeManager.getCurrentNode().getNodeVersion());
        this.plannerContext = new PlannerContext(metadata, typeOperators, blockEncodingSerde, typeManager);
        this.splitManager = new SplitManager(new QueryManagerConfig());
        this.planFragmenter = new PlanFragmenter(metadata, this.nodePartitioningManager, new QueryManagerConfig());
        this.joinCompiler = new JoinCompiler(typeOperators);
        GroupByHashPageIndexerFactory pageIndexerFactory = new GroupByHashPageIndexerFactory(this.joinCompiler, this.blockTypeOperators);
        this.groupProvider = new TestingGroupProvider();
        this.accessControl = new TestingAccessControlManager(this.transactionManager, this.eventListenerManager);
        this.accessControl.loadSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
        TableProceduresRegistry tableProceduresRegistry = new TableProceduresRegistry();
        this.sessionPropertyManager = LocalQueryRunner.createSessionPropertyManager(extraSessionProperties, this.taskManagerConfig, featuresConfig, this.optimizerConfig);
        this.schemaPropertyManager = new SchemaPropertyManager();
        this.columnPropertyManager = new ColumnPropertyManager();
        this.tablePropertyManager = new TablePropertyManager();
        this.materializedViewPropertyManager = new MaterializedViewPropertyManager();
        this.analyzePropertyManager = new AnalyzePropertyManager();
        TableProceduresPropertyManager tableProceduresPropertyManager = new TableProceduresPropertyManager();
        this.statementAnalyzerFactory = new StatementAnalyzerFactory(this.plannerContext, this.sqlParser, this.accessControl, this.groupProvider, tableProceduresRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, tableProceduresPropertyManager);
        TypeAnalyzer typeAnalyzer = new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory);
        this.statsCalculator = LocalQueryRunner.createNewStatsCalculator(this.plannerContext, typeAnalyzer);
        this.scalarStatsCalculator = new ScalarStatsCalculator(this.plannerContext, typeAnalyzer);
        this.taskCountEstimator = new TaskCountEstimator(() -> nodeCountForStats);
        this.costCalculator = new CostCalculatorUsingExchanges(this.taskCountEstimator);
        this.estimatedExchangesCostCalculator = new CostCalculatorWithEstimatedExchanges(this.costCalculator, this.taskCountEstimator);
        this.pageSourceManager = new PageSourceManager();
        this.pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        this.expressionCompiler = new ExpressionCompiler(metadata, this.pageFunctionCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(metadata);
        HandleResolver handleResolver = new HandleResolver();
        NodeInfo nodeInfo = new NodeInfo("test");
        this.connectorManager = new ConnectorManager(metadata, this.catalogManager, this.accessControl, this.splitManager, this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, handleResolver, this.nodeManager, nodeInfo, EmbedVersion.testingVersionEmbedder(), pageSorter, pageIndexerFactory, this.transactionManager, this.eventListenerManager, typeManager, new ProcedureRegistry(), tableProceduresRegistry, this.sessionPropertyManager, this.schemaPropertyManager, this.columnPropertyManager, this.tablePropertyManager, this.materializedViewPropertyManager, this.analyzePropertyManager, tableProceduresPropertyManager, nodeSchedulerConfig);
        GlobalSystemConnectorFactory globalSystemConnectorFactory = new GlobalSystemConnectorFactory((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(metadata, this.accessControl), (Object)new TableCommentSystemTable(metadata, this.accessControl), (Object)new MaterializedViewSystemTable(metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(this.transactionManager, this.schemaPropertyManager), (Object)new TablePropertiesSystemTable(this.transactionManager, this.tablePropertyManager), (Object[])new SystemTable[]{new MaterializedViewPropertiesSystemTable(this.transactionManager, this.materializedViewPropertyManager), new ColumnPropertiesSystemTable(this.transactionManager, this.columnPropertyManager), new AnalyzePropertiesSystemTable(this.transactionManager, this.analyzePropertyManager), new TransactionsSystemTable(typeManager, this.transactionManager)}), (Set<Procedure>)ImmutableSet.of());
        this.exchangeManagerRegistry = new ExchangeManagerRegistry(new ExchangeHandleResolver());
        this.pluginManager = new PluginManager((loader, createClassLoader) -> {}, this.connectorManager, metadata, new NoOpResourceGroupManager(), this.accessControl, Optional.of(new PasswordAuthenticatorManager(new PasswordAuthenticatorConfig())), new CertificateAuthenticatorManager(), Optional.of(new HeaderAuthenticatorManager(new HeaderAuthenticatorConfig())), this.eventListenerManager, new GroupProviderManager(), new SessionPropertyDefaults(nodeInfo, this.accessControl), typeRegistry, blockEncodingManager, handleResolver, this.exchangeManagerRegistry);
        this.connectorManager.addConnectorFactory(globalSystemConnectorFactory, ignored -> globalSystemConnectorFactory.getClass().getClassLoader());
        this.connectorManager.createCatalog("system", "system", (Map<String, String>)ImmutableMap.of());
        Optional<TransactionId> transactionId = withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(true)) : defaultSession.getTransactionId();
        this.defaultSession = new Session(defaultSession.getQueryId(), transactionId, defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getPath(), defaultSession.getTraceToken(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getClientTags(), defaultSession.getClientCapabilities(), defaultSession.getResourceEstimates(), defaultSession.getStart(), defaultSession.getSystemProperties(), defaultSession.getCatalogProperties(), this.sessionPropertyManager, defaultSession.getPreparedStatements(), defaultSession.getProtocolHeaders());
        SpillerStats spillerStats = new SpillerStats();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.plannerContext.getBlockEncodingSerde(), spillerStats, featuresConfig, nodeSpillConfig);
        this.partitioningSpillerFactory = new GenericPartitioningSpillerFactory(this.singleStreamSpillerFactory);
        this.spillerFactory = new GenericSpillerFactory(this.singleStreamSpillerFactory);
    }

    private static SessionPropertyManager createSessionPropertyManager(Set<SystemSessionPropertiesProvider> extraSessionProperties, TaskManagerConfig taskManagerConfig, FeaturesConfig featuresConfig, OptimizerConfig optimizerConfig) {
        ImmutableSet systemSessionProperties = ImmutableSet.builder().addAll((Iterable)Objects.requireNonNull(extraSessionProperties, "extraSessionProperties is null")).add((Object)new SystemSessionProperties(new QueryManagerConfig(), taskManagerConfig, new MemoryManagerConfig(), featuresConfig, optimizerConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig())).build();
        return new SessionPropertyManager((Set<SystemSessionPropertiesProvider>)systemSessionProperties);
    }

    private static StatsCalculator createNewStatsCalculator(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(plannerContext, typeAnalyzer);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(plannerContext, scalarStatsCalculator, normalizer);
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)new StatsCalculatorModule.StatsRulesProvider(plannerContext, scalarStatsCalculator, filterStatsCalculator, normalizer).get());
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.connectorManager.stop();
        this.finalizerService.destroy();
        this.singleStreamSpillerFactory.destroy();
    }

    public void loadEventListeners() {
        this.eventListenerManager.loadEventListeners();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public Metadata getMetadata() {
        return this.plannerContext.getMetadata();
    }

    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    public ColumnPropertyManager getColumnPropertyManager() {
        return this.columnPropertyManager;
    }

    public MaterializedViewPropertyManager getMaterializedViewPropertyManager() {
        return this.materializedViewPropertyManager;
    }

    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.plannerContext.getTypeManager();
    }

    @Override
    public QueryExplainer getQueryExplainer() {
        QueryExplainerFactory queryExplainerFactory = this.createQueryExplainerFactory(this.getPlanOptimizers(true));
        AnalyzerFactory analyzerFactory = this.createAnalyzerFactory(queryExplainerFactory);
        return queryExplainerFactory.createQueryExplainer(analyzerFactory);
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    public TypeOperators getTypeOperators() {
        return this.plannerContext.getTypeOperators();
    }

    public BlockTypeOperators getBlockTypeOperators() {
        return this.blockTypeOperators;
    }

    @Override
    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    @Override
    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    @Override
    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    @Override
    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    public CostCalculator getEstimatedExchangesCostCalculator() {
        return this.estimatedExchangesCostCalculator;
    }

    @Override
    public TestingGroupProvider getGroupProvider() {
        return this.groupProvider;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ExecutorService getExecutor() {
        return this.notificationExecutor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.yieldExecutor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeConnector(new CatalogName(catalogName));
        this.connectorManager.addConnectorFactory(connectorFactory, ignored -> connectorFactory.getClass().getClassLoader());
        this.connectorManager.createCatalog(catalogName, connectorFactory.getName(), properties);
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin, ignored -> plugin.getClass().getClassLoader());
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functions) {
        this.plannerContext.getMetadata().addFunctions(functions);
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeConnector(new CatalogName(catalogName));
        this.connectorManager.createCatalog(catalogName, connectorName, properties);
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeWithPlan(session, sql, WarningCollector.NOOP).getMaterializedResult();
    }

    @Override
    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        return this.inTransaction(session, transactionSession -> this.executeInternal((Session)transactionSession, sql));
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.defaultSession, transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.transactionManager, this.accessControl).singleStatement().execute(session, transactionSessionConsumer);
    }

    private QueryRunner.MaterializedResultWithPlan executeInternal(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            QueryRunner.MaterializedResultWithPlan materializedResultWithPlan;
            block14: {
                Closer closer = Closer.create();
                try {
                    this.accessControl.checkCanExecuteQuery(session.getIdentity());
                    AtomicReference builder = new AtomicReference();
                    PageConsumerOperator.PageConsumerOutputFactory outputFactory = new PageConsumerOperator.PageConsumerOutputFactory(types -> {
                        builder.compareAndSet(null, MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)types));
                        return ((MaterializedResult.Builder)builder.get())::page;
                    });
                    TaskContext taskContext = TestingTaskContext.builder(this.notificationExecutor, this.yieldExecutor, session).setMaxSpillSize(this.nodeSpillConfig.getMaxSpillPerNode()).setQueryMaxSpillSize(this.nodeSpillConfig.getQueryMaxSpillPerNode()).build();
                    Plan plan = this.createPlan(session, sql, WarningCollector.NOOP);
                    List<Driver> drivers = this.createDrivers(session, plan, (OutputFactory)outputFactory, taskContext);
                    drivers.forEach(arg_0 -> ((Closer)closer).register(arg_0));
                    boolean done = false;
                    while (!done) {
                        boolean processed = false;
                        for (Driver driver : drivers) {
                            if (this.alwaysRevokeMemory) {
                                driver.getDriverContext().getOperatorContexts().stream().filter(operatorContext -> operatorContext.getNestedOperatorStats().stream().mapToLong(stats -> stats.getRevocableMemoryReservation().toBytes()).sum() > 0L).forEach(OperatorContext::requestMemoryRevoking);
                            }
                            if (driver.isFinished()) continue;
                            driver.process();
                            processed = true;
                        }
                        done = !processed;
                    }
                    Verify.verify((builder.get() != null ? 1 : 0) != 0, (String)"Output operator was not created", (Object[])new Object[0]);
                    materializedResultWithPlan = new QueryRunner.MaterializedResultWithPlan(((MaterializedResult.Builder)builder.get()).build(), plan);
                    if (closer == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (closer != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                closer.close();
            }
            return materializedResultWithPlan;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    @Override
    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        throw new UnsupportedOperationException("failure injection is not supported");
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    @Override
    public void loadExchangeManager(String name, Map<String, String> properties) {
        this.exchangeManagerRegistry.loadExchangeManager(name, properties);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        Plan plan = this.createPlan(session, sql, WarningCollector.NOOP);
        return this.createDrivers(session, plan, outputFactory, taskContext);
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode) {
        return this.planFragmenter.createSubPlans(session, plan, forceSingleNode, WarningCollector.NOOP);
    }

    private List<Driver> createDrivers(Session session, Plan plan, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.plannerContext.getMetadata(), plan.getStatsAndCosts(), session, 0, false));
        }
        if (!(subplan = this.createSubPlans(session, plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        TableExecuteContextManager tableExecuteContextManager = new TableExecuteContextManager();
        tableExecuteContextManager.registerTableExecuteContextForQuery(taskContext.getQueryContext().getQueryId());
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.plannerContext, new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), Optional.empty(), this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, null, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), this.taskManagerConfig, this.spillerFactory, this.singleStreamSpillerFactory, this.partitioningSpillerFactory, new PagesIndex.TestingFactory(false), this.joinCompiler, this.operatorFactories, new OrderingCompiler(this.plannerContext.getTypeOperators()), new DynamicFilterConfig(), this.blockTypeOperators, tableExecuteContextManager, this.exchangeManagerRegistry);
        StageExecutionDescriptor stageExecutionDescriptor = subplan.getFragment().getStageExecutionDescriptor();
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, stageExecutionDescriptor, subplan.getFragment().getRoot(), subplan.getFragment().getPartitioningScheme().getOutputLayout(), plan.getTypes(), subplan.getFragment().getPartitionedSources(), outputFactory);
        ArrayList<SplitAssignment> splitAssignments = new ArrayList<SplitAssignment>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            TableHandle table = tableScan.getTable();
            SplitSource splitSource = this.splitManager.getSplits(session, table, stageExecutionDescriptor.isScanGroupedExecution(tableScan.getId()) ? ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING : ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, DynamicFilter.EMPTY, Constraint.alwaysTrue());
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : LocalQueryRunner.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            splitAssignments.add(new SplitAssignment(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        ImmutableSet partitionedSources = ImmutableSet.copyOf(subplan.getFragment().getPartitionedSources());
        for (SplitAssignment splitAssignment : splitAssignments) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(splitAssignment.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            boolean partitioned = partitionedSources.contains((Object)driverFactory.getSourceId().get());
            for (ScheduledSplit split : splitAssignment.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSplitAssignment(new SplitAssignment(split.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    @Override
    public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        return this.createPlan(session, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, WarningCollector warningCollector) {
        return this.createPlan(session, sql, stage, true, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode, WarningCollector warningCollector) {
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, sql);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)ParsingUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        return this.createPlan(session, sql, this.getPlanOptimizers(forceSingleNode), stage, warningCollector);
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean forceSingleNode) {
        return this.planOptimizersProvider.getPlanOptimizers(this.plannerContext, new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), this.taskManagerConfig, forceSingleNode, this.splitManager, this.pageSourceManager, this.statsCalculator, this.scalarStatsCalculator, this.costCalculator, this.estimatedExchangesCostCalculator, new CostComparator(this.optimizerConfig), this.taskCountEstimator, this.nodePartitioningManager, new RuleStatsRecorder()).get();
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, WarningCollector warningCollector) {
        return this.createPlan(session, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, LogicalPlanner.Stage stage, WarningCollector warningCollector) {
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, sql);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)ParsingUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        AnalyzerFactory analyzerFactory = this.createAnalyzerFactory(this.createQueryExplainerFactory(optimizers));
        Analyzer analyzer = analyzerFactory.createAnalyzer(session, preparedQuery.getParameters(), ParameterUtils.parameterExtractor(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, optimizers, new PlanSanityChecker(true), idAllocator, this.getPlannerContext(), new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), this.statsCalculator, this.costCalculator, warningCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        return logicalPlanner.plan(analysis, stage);
    }

    private QueryExplainerFactory createQueryExplainerFactory(List<PlanOptimizer> optimizers) {
        return new QueryExplainerFactory(() -> optimizers, this.planFragmenter, this.plannerContext, this.statementAnalyzerFactory, this.statsCalculator, this.costCalculator);
    }

    private AnalyzerFactory createAnalyzerFactory(QueryExplainerFactory queryExplainerFactory) {
        return new AnalyzerFactory(this.statementAnalyzerFactory, new StatementRewrite((Set<StatementRewrite.Rewrite>)ImmutableSet.of((Object)new DescribeInputRewrite(this.sqlParser), (Object)new DescribeOutputRewrite(this.sqlParser), (Object)new ShowQueriesRewrite(this.plannerContext.getMetadata(), this.sqlParser, this.accessControl, this.sessionPropertyManager, this.schemaPropertyManager, this.columnPropertyManager, this.tablePropertyManager, this.materializedViewPropertyManager), (Object)new ShowStatsRewrite(queryExplainerFactory, this.statsCalculator), (Object)new ExplainRewrite(queryExplainerFactory, new QueryPreparer(this.sqlParser)))));
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).findAll();
    }

    public static class Builder {
        private final Session defaultSession;
        private FeaturesConfig featuresConfig = new FeaturesConfig();
        private NodeSpillConfig nodeSpillConfig = new NodeSpillConfig();
        private boolean initialTransaction;
        private boolean alwaysRevokeMemory;
        private Map<String, List<PropertyMetadata<?>>> defaultSessionProperties = ImmutableMap.of();
        private Set<SystemSessionPropertiesProvider> extraSessionProperties = ImmutableSet.of();
        private int nodeCountForStats;
        private PlanOptimizersProvider planOptimizersProvider = PlanOptimizers::new;
        private OperatorFactories operatorFactories = new TrinoOperatorFactories();

        private Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public Builder withFeaturesConfig(FeaturesConfig featuresConfig) {
            this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
            return this;
        }

        public Builder withNodeSpillConfig(NodeSpillConfig nodeSpillConfig) {
            this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
            return this;
        }

        public Builder withInitialTransaction() {
            this.initialTransaction = true;
            return this;
        }

        public Builder withAlwaysRevokeMemory() {
            this.alwaysRevokeMemory = true;
            return this;
        }

        public Builder withDefaultSessionProperties(Map<String, List<PropertyMetadata<?>>> defaultSessionProperties) {
            this.defaultSessionProperties = Objects.requireNonNull(defaultSessionProperties, "defaultSessionProperties is null");
            return this;
        }

        public Builder withNodeCountForStats(int nodeCountForStats) {
            this.nodeCountForStats = nodeCountForStats;
            return this;
        }

        public Builder withPlanOptimizersProvider(PlanOptimizersProvider planOptimizersProvider) {
            this.planOptimizersProvider = Objects.requireNonNull(planOptimizersProvider, "planOptimizersProvider is null");
            return this;
        }

        public Builder withOperatorFactories(OperatorFactories operatorFactories) {
            this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
            return this;
        }

        public Builder withExtraSystemSessionProperties(Set<SystemSessionPropertiesProvider> extraSessionProperties) {
            this.extraSessionProperties = ImmutableSet.copyOf((Collection)Objects.requireNonNull(extraSessionProperties, "extraSessionProperties is null"));
            return this;
        }

        public LocalQueryRunner build() {
            return new LocalQueryRunner(this.defaultSession, this.featuresConfig, this.nodeSpillConfig, this.initialTransaction, this.alwaysRevokeMemory, this.nodeCountForStats, this.defaultSessionProperties, this.planOptimizersProvider, this.operatorFactories, this.extraSessionProperties);
        }
    }

    public static interface PlanOptimizersProvider {
        public PlanOptimizersFactory getPlanOptimizers(PlannerContext var1, TypeAnalyzer var2, TaskManagerConfig var3, boolean var4, SplitManager var5, PageSourceManager var6, StatsCalculator var7, ScalarStatsCalculator var8, CostCalculator var9, CostCalculator var10, CostComparator var11, TaskCountEstimator var12, NodePartitioningManager var13, RuleStatsRecorder var14);
    }
}

