/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static int expectedValueSize(Type type, int defaultSize) {
        if (type instanceof FixedWidthType) {
            return ((FixedWidthType)type).getFixedSize();
        }
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().map(length -> Math.min(length, defaultSize)).orElse(defaultSize);
        }
        if (type instanceof CharType) {
            return Math.min(((CharType)type).getLength(), defaultSize);
        }
        return defaultSize;
    }

    public static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }

    public static String getDisplayLabel(Type type, boolean legacy) {
        if (legacy) {
            return TypeUtils.getDisplayLabelForLegacyClients(type);
        }
        return type.getDisplayName();
    }

    private static String getDisplayLabelForLegacyClients(Type type) {
        if (type instanceof TimestampType && ((TimestampType)type).getPrecision() == 3) {
            return "timestamp";
        }
        if (type instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)type).getPrecision() == 3) {
            return "timestamp with time zone";
        }
        if (type instanceof TimeType && ((TimeType)type).getPrecision() == 3) {
            return "time";
        }
        if (type instanceof TimeWithTimeZoneType && ((TimeWithTimeZoneType)type).getPrecision() == 3) {
            return "time with time zone";
        }
        if (type instanceof ArrayType) {
            return "array(" + TypeUtils.getDisplayLabelForLegacyClients(((ArrayType)type).getElementType()) + ")";
        }
        if (type instanceof MapType) {
            return "map(" + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getKeyType()) + ", " + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getValueType()) + ")";
        }
        if (type instanceof RowType) {
            return TypeUtils.getRowDisplayLabelForLegacyClients((RowType)type);
        }
        return type.getDisplayName();
    }

    private static String getRowDisplayLabelForLegacyClients(RowType type) {
        List fields = (List)type.getFields().stream().map(field -> {
            String typeDisplayName = TypeUtils.getDisplayLabelForLegacyClients(field.getType());
            if (field.getName().isPresent()) {
                return (String)field.getName().get() + " " + typeDisplayName;
            }
            return typeDisplayName;
        }).collect(ImmutableList.toImmutableList());
        return String.format("%s(%s)", "row", Joiner.on((String)", ").join((Iterable)fields));
    }
}

