/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.atop.AtopConnector;
import io.trino.plugin.atop.AtopConnectorConfig;
import io.trino.plugin.atop.AtopFactory;
import io.trino.plugin.atop.AtopMetadata;
import io.trino.plugin.atop.AtopPageSourceProvider;
import io.trino.plugin.atop.AtopSplitManager;
import io.trino.plugin.atop.Environment;
import io.trino.spi.NodeManager;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class AtopModule
implements Module {
    private final Class<? extends AtopFactory> atopFactoryClass;
    private final TypeManager typeManager;
    private final NodeManager nodeManager;
    private final String environment;

    public AtopModule(Class<? extends AtopFactory> atopFactoryClass, TypeManager typeManager, NodeManager nodeManager, String environment) {
        this.atopFactoryClass = Objects.requireNonNull(atopFactoryClass, "atopFactoryClass is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(Environment.class).toInstance((Object)new Environment(this.environment));
        binder.bind(AtopConnector.class).in(Scopes.SINGLETON);
        binder.bind(AtopMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AtopSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(AtopFactory.class).to(this.atopFactoryClass).in(Scopes.SINGLETON);
        binder.bind(AtopPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AtopConnectorConfig.class);
    }
}

