/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.atop.AtopColumnHandle;
import io.trino.plugin.atop.AtopConnectorConfig;
import io.trino.plugin.atop.AtopFactory;
import io.trino.plugin.atop.AtopPageSource;
import io.trino.plugin.atop.AtopSplit;
import io.trino.plugin.atop.AtopTable;
import io.trino.plugin.atop.AtopTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import javax.inject.Inject;

public final class AtopPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Semaphore readerPermits;
    private final AtopFactory atopFactory;
    private final TypeManager typeManager;

    @Inject
    public AtopPageSourceProvider(AtopConnectorConfig config, AtopFactory atopFactory, TypeManager typeManager) {
        this.readerPermits = new Semaphore(Objects.requireNonNull(config, "config is null").getConcurrentReadersPerNode());
        this.atopFactory = Objects.requireNonNull(atopFactory, "atopFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        AtopTableHandle tableHandle = (AtopTableHandle)table;
        AtopSplit atopSplit = (AtopSplit)split;
        ImmutableList.Builder types = ImmutableList.builder();
        ImmutableList.Builder atopColumns = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            AtopColumnHandle atopColumnHandle = (AtopColumnHandle)column;
            AtopTable.AtopColumn atopColumn = tableHandle.getTable().getColumn(atopColumnHandle.getName());
            atopColumns.add((Object)atopColumn);
            types.add((Object)this.typeManager.getType(atopColumn.getType()));
        }
        ZonedDateTime date = atopSplit.getDate();
        Preconditions.checkArgument((boolean)date.equals(date.withHour(0).withMinute(0).withSecond(0).withNano(0)), (Object)"Expected date to be at beginning of day");
        return new AtopPageSource(this.readerPermits, this.atopFactory, session, Slices.utf8Slice((String)atopSplit.getHost().getHostText()), tableHandle.getTable(), date, (List<AtopTable.AtopColumn>)atopColumns.build(), (List<Type>)types.build());
    }
}

