/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import io.trino.plugin.atop.AtopConnectorConfig;
import io.trino.plugin.atop.AtopSplit;
import io.trino.plugin.atop.AtopTableHandle;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;

public class AtopSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final ZoneId timeZone;
    private final int maxHistoryDays;

    @Inject
    public AtopSplitManager(NodeManager nodeManager, AtopConnectorConfig config) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(config, "config is null");
        this.timeZone = config.getTimeZoneId();
        this.maxHistoryDays = config.getMaxHistoryDays();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        AtopTableHandle tableHandle = (AtopTableHandle)table;
        ArrayList<AtopSplit> splits = new ArrayList<AtopSplit>();
        ZonedDateTime end = ZonedDateTime.now(this.timeZone);
        for (Node node : this.nodeManager.getWorkerNodes()) {
            ZonedDateTime start = end.minusDays(this.maxHistoryDays - 1).withHour(0).withMinute(0).withSecond(0).withNano(0);
            while (start.isBefore(end)) {
                ZonedDateTime splitEnd = start.withHour(23).withMinute(59).withSecond(59).withNano(0);
                Domain splitDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Object)DateTimeEncoding.packDateTimeWithZone((long)start.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY), (boolean)true, (Object)DateTimeEncoding.packDateTimeWithZone((long)splitEnd.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY), (boolean)true), (Range[])new Range[0]), (boolean)false);
                if (tableHandle.getStartTimeConstraint().overlaps(splitDomain) && tableHandle.getEndTimeConstraint().overlaps(splitDomain)) {
                    splits.add(new AtopSplit(node.getHostAndPort(), start.toEpochSecond(), start.getZone().getId()));
                }
                start = start.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            }
        }
        return new FixedSplitSource(splits);
    }
}

