/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AtopTable {
    DISKS("disks", "DSK", AtopTable.baseColumnsAnd(new AtopColumn("device_name", VarcharType.VARCHAR.getTypeSignature(), AtopColumnParser.varcharParser(6)), new AtopColumn("utilization_percent", DoubleType.DOUBLE.getTypeSignature(), (fields, type, builder, session) -> {
        long durationMillis = Long.valueOf((String)fields.get(5)) * 1000L;
        long ioMillis = Long.valueOf((String)fields.get(7));
        double utilization = Math.round(100.0 * (double)ioMillis / (double)durationMillis);
        if (utilization > 100.0) {
            utilization = 100.0;
        }
        type.writeDouble(builder, utilization);
    }), new AtopColumn("io_time", new TypeSignature("interval day to second", new TypeSignatureParameter[0]), (fields, type, builder, session) -> {
        long millis = Long.valueOf((String)fields.get(7));
        type.writeLong(builder, millis);
    }), new AtopColumn("read_requests", BigintType.BIGINT.getTypeSignature(), AtopColumnParser.bigintParser(8)), new AtopColumn("sectors_read", BigintType.BIGINT.getTypeSignature(), AtopColumnParser.bigintParser(9)), new AtopColumn("write_requests", BigintType.BIGINT.getTypeSignature(), AtopColumnParser.bigintParser(10)), new AtopColumn("sectors_written", BigintType.BIGINT.getTypeSignature(), AtopColumnParser.bigintParser(11)))),
    REBOOTS("reboots", "DSK", (List<AtopColumn>)ImmutableList.of((Object)AtopColumn.HOST_IP, (Object)new AtopColumn("power_on_time", TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getTypeSignature(), (fields, type, builder, session) -> {
        long millisUtc = Long.valueOf((String)fields.get(2)) * 1000L;
        long durationMillis = Long.valueOf((String)fields.get(5)) * 1000L;
        long value = DateTimeEncoding.packDateTimeWithZone((long)(millisUtc - durationMillis), (TimeZoneKey)session.getTimeZoneKey());
        type.writeLong(builder, value);
    })));

    private final String name;
    private final String atopLabel;
    private final List<AtopColumn> columns;
    private final Map<String, AtopColumn> columnIndex;

    private AtopTable(String name, String atopLabel, List<AtopColumn> columns) {
        this.atopLabel = atopLabel;
        this.name = Objects.requireNonNull(name, "name is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.columnIndex = this.columns.stream().collect(Collectors.toMap(AtopColumn::getName, Function.identity()));
    }

    private static List<AtopColumn> baseColumnsAnd(AtopColumn ... additionalColumns) {
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.add((Object)AtopColumn.HOST_IP);
        columns.add((Object)AtopColumn.START_TIME);
        columns.add((Object)AtopColumn.END_TIME);
        columns.addAll(Arrays.asList(additionalColumns));
        return columns.build();
    }

    public String getName() {
        return this.name;
    }

    public String getAtopLabel() {
        return this.atopLabel;
    }

    public AtopColumn getColumn(String name) {
        return this.columnIndex.get(name);
    }

    public List<AtopColumn> getColumns() {
        return this.columns;
    }

    public static interface AtopColumnParser {
        public void parse(List<String> var1, Type var2, BlockBuilder var3, ConnectorSession var4);

        public static AtopColumnParser varcharParser(int index) {
            return (fields, type, builder, session) -> type.writeSlice(builder, Slices.utf8Slice((String)((String)fields.get(index))));
        }

        public static AtopColumnParser bigintParser(int index) {
            return (fields, type, builder, session) -> type.writeLong(builder, Long.valueOf((String)fields.get(index)).longValue());
        }
    }

    public static class AtopColumn {
        public static final AtopColumn HOST_IP = new AtopColumn("host_ip", VarcharType.VARCHAR.getTypeSignature(), (fields, type, builder, session) -> {
            throw new UnsupportedOperationException();
        });
        public static final AtopColumn START_TIME = new AtopColumn("start_time", TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getTypeSignature(), (fields, type, builder, session) -> {
            long millisUtc = Long.valueOf((String)fields.get(2)) * 1000L;
            long durationMillis = Long.valueOf((String)fields.get(5)) * 1000L;
            long value = DateTimeEncoding.packDateTimeWithZone((long)(millisUtc - durationMillis), (TimeZoneKey)session.getTimeZoneKey());
            type.writeLong(builder, value);
        });
        public static final AtopColumn END_TIME = new AtopColumn("end_time", TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getTypeSignature(), (fields, type, builder, session) -> {
            long millisUtc = Long.valueOf((String)fields.get(2)) * 1000L;
            type.writeLong(builder, DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)session.getTimeZoneKey()));
        });
        private final String name;
        private final TypeSignature type;
        private final AtopColumnParser parser;

        private AtopColumn(String name, TypeSignature type, AtopColumnParser parser) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
        }

        public String getName() {
            return this.name;
        }

        public TypeSignature getType() {
            return this.type;
        }

        public AtopColumnParser getParser() {
            return this.parser;
        }
    }
}

