/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.salesforce;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class SalesforceConfig {
    private int cacheSize = 4096;
    private Duration cacheExpireDuration = Duration.succinctDuration((double)2.0, (TimeUnit)TimeUnit.MINUTES);
    private String allowedOrganizations;

    @NotNull(message="Must set salesforce.allowed-organization with one or more Salesforce 18 char Organization Ids, or \"all\"")
    public @NotNull(message="Must set salesforce.allowed-organization with one or more Salesforce 18 char Organization Ids, or \"all\"") String getAllowedOrganizations() {
        return this.allowedOrganizations;
    }

    public Set<String> getOrgSet() {
        String[] orgsSplit;
        HashSet<String> tmp = new HashSet<String>();
        if (this.allowedOrganizations == null) {
            this.allowedOrganizations = "";
        }
        for (String s : orgsSplit = this.allowedOrganizations.split("[,;]")) {
            tmp.add(s.toLowerCase(Locale.US).trim());
        }
        return tmp;
    }

    @Config(value="salesforce.allowed-organizations")
    @ConfigDescription(value="Comma separated list of Salesforce 18 Character Organization Ids.")
    public SalesforceConfig setAllowedOrganizations(String allowedOrganizations) {
        this.allowedOrganizations = allowedOrganizations;
        return this;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Config(value="salesforce.cache-size")
    @ConfigDescription(value="Maximum size of the cache that holds authenticated users.  Default is 4096 entries.")
    public SalesforceConfig setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    @MaxDuration(value="1h")
    public @MaxDuration(value="1h") Duration getCacheExpireDuration() {
        return this.cacheExpireDuration;
    }

    @Config(value="salesforce.cache-expire-duration")
    @ConfigDescription(value="Expire duration for an entry in cache since last write.")
    public SalesforceConfig setCacheExpireDuration(Duration cacheExpireDuration) {
        this.cacheExpireDuration = cacheExpireDuration;
        return this;
    }
}

