/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.trino.plugin.hive.CachingDirectoryLister;
import io.trino.plugin.hive.DirectoryLister;
import io.trino.plugin.hive.TableInvalidationCallback;
import java.util.Objects;
import java.util.Optional;

public class CachingDirectoryListerModule
implements Module {
    private final Optional<CachingDirectoryLister> cachingDirectoryLister;

    public CachingDirectoryListerModule(Optional<CachingDirectoryLister> cachingDirectoryLister) {
        this.cachingDirectoryLister = Objects.requireNonNull(cachingDirectoryLister, "cachingDirectoryLister is null");
    }

    public void configure(Binder binder) {
        if (this.cachingDirectoryLister.isPresent()) {
            CachingDirectoryLister directoryLister = this.cachingDirectoryLister.get();
            binder.bind(DirectoryLister.class).toInstance((Object)directoryLister);
            binder.bind(TableInvalidationCallback.class).toInstance((Object)directoryLister);
        } else {
            binder.bind(CachingDirectoryLister.class).in(Scopes.SINGLETON);
            binder.bind(DirectoryLister.class).to(CachingDirectoryLister.class);
            binder.bind(TableInvalidationCallback.class).to(CachingDirectoryLister.class);
        }
    }
}

