/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTableRedirectionsProvider;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorSession;
import java.util.Optional;

public class DefaultHiveTableRedirectionsProvider
implements HiveTableRedirectionsProvider {
    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, Table table) {
        Optional<String> targetCatalogName = HiveSessionProperties.getIcebergCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isIcebergTable(table)) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, table.getSchemaTableName()));
        }
        return Optional.empty();
    }
}

