/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.util.ForwardingRecordCursor;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveBucketAdapterRecordCursor
extends ForwardingRecordCursor {
    private final RecordCursor delegate;
    private final int[] bucketColumnIndices;
    private final List<Class<?>> javaTypeList;
    private final List<TypeInfo> typeInfoList;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int tableBucketCount;
    private final int partitionBucketCount;
    private final int bucketToKeep;
    private final Object[] scratch;

    public HiveBucketAdapterRecordCursor(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, int bucketToKeep, TypeManager typeManager, RecordCursor delegate) {
        this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(bucketColumnHiveTypes, "bucketColumnHiveTypes is null");
        this.javaTypeList = (List)bucketColumnHiveTypes.stream().map(HiveType::getTypeSignature).map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).map(Type::getJavaType).collect(ImmutableList.toImmutableList());
        this.typeInfoList = (List)bucketColumnHiveTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.tableBucketCount = tableBucketCount;
        this.partitionBucketCount = partitionBucketCount;
        this.bucketToKeep = bucketToKeep;
        this.scratch = new Object[bucketColumnHiveTypes.size()];
    }

    @Override
    protected RecordCursor delegate() {
        return this.delegate;
    }

    @Override
    public boolean advanceNextPosition() {
        int bucket;
        do {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "RecordCursor was interrupted");
            }
            boolean hasNextPosition = this.delegate.advanceNextPosition();
            if (!hasNextPosition) {
                return false;
            }
            for (int i = 0; i < this.scratch.length; ++i) {
                int index = this.bucketColumnIndices[i];
                if (this.delegate.isNull(index)) {
                    this.scratch[i] = null;
                    continue;
                }
                Class<?> javaType = this.javaTypeList.get(i);
                if (javaType == Boolean.TYPE) {
                    this.scratch[i] = this.delegate.getBoolean(index);
                    continue;
                }
                if (javaType == Long.TYPE) {
                    this.scratch[i] = this.delegate.getLong(index);
                    continue;
                }
                if (javaType == Double.TYPE) {
                    this.scratch[i] = this.delegate.getDouble(index);
                    continue;
                }
                if (javaType == Slice.class) {
                    this.scratch[i] = this.delegate.getSlice(index);
                    continue;
                }
                if (javaType == Block.class) {
                    this.scratch[i] = this.delegate.getObject(index);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown java type: " + javaType);
            }
            bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, this.scratch);
            if ((bucket - this.bucketToKeep) % this.partitionBucketCount == 0) continue;
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
        } while (bucket != this.bucketToKeep);
        return true;
    }
}

