/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.procedure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class FlushHiveMetastoreCacheProcedure
implements Provider<Procedure> {
    private static final String PROCEDURE_NAME = "flush_metadata_cache";
    private static final String PARAM_SCHEMA_NAME = "SCHEMA_NAME";
    private static final String PARAM_TABLE_NAME = "TABLE_NAME";
    private static final String PARAM_PARTITION_COLUMN = "PARTITION_COLUMN";
    private static final String PARAM_PARTITION_VALUE = "PARTITION_VALUE";
    private static final String PROCEDURE_USAGE_EXAMPLES = String.format("Valid usages:%n - '%1$s()'%n - %1$s(%2$s => ..., %3$s => ..., %4$s => ARRAY['...'], %5$s => ARRAY['...'])", "flush_metadata_cache", "SCHEMA_NAME".toLowerCase(Locale.ENGLISH), "TABLE_NAME".toLowerCase(Locale.ENGLISH), "PARTITION_COLUMN".toLowerCase(Locale.ENGLISH), "PARTITION_VALUE".toLowerCase(Locale.ENGLISH));
    private static final MethodHandle FLUSH_HIVE_METASTORE_CACHE = MethodHandleUtil.methodHandle(FlushHiveMetastoreCacheProcedure.class, (String)"flushMetadataCache", (Class[])new Class[]{String.class, String.class, String.class, List.class, List.class});
    private static final String FAKE_PARAM_DEFAULT_VALUE = "procedure should only be invoked with named parameters";
    private final Optional<CachingHiveMetastore> cachingHiveMetastore;

    @Inject
    public FlushHiveMetastoreCacheProcedure(Optional<CachingHiveMetastore> cachingHiveMetastore) {
        this.cachingHiveMetastore = Objects.requireNonNull(cachingHiveMetastore, "cachingHiveMetastore is null");
    }

    public Procedure get() {
        return new Procedure("system", PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument("$FAKE_FIRST_PARAMETER", (Type)VarcharType.VARCHAR, false, (Object)FAKE_PARAM_DEFAULT_VALUE), (Object)new Procedure.Argument(PARAM_SCHEMA_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_TABLE_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_PARTITION_COLUMN, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null), (Object)new Procedure.Argument(PARAM_PARTITION_VALUE, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null)), FLUSH_HIVE_METASTORE_CACHE.bindTo(this));
    }

    public void flushMetadataCache(String fakeParam, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValue) {
        Preconditions.checkState((boolean)FAKE_PARAM_DEFAULT_VALUE.equals(fakeParam), (Object)("Procedure should only be invoked with named parameters. " + PROCEDURE_USAGE_EXAMPLES));
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doFlushMetadataCache(Optional.ofNullable(schemaName), Optional.ofNullable(tableName), Optional.ofNullable(partitionColumn).orElse((List<String>)ImmutableList.of()), Optional.ofNullable(partitionValue).orElse((List<String>)ImmutableList.of()));
        }
    }

    private void doFlushMetadataCache(Optional<String> schemaName, Optional<String> tableName, List<String> partitionColumns, List<String> partitionValues) {
        CachingHiveMetastore cachingHiveMetastore = this.cachingHiveMetastore.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot flush, metastore cache is not enabled"));
        Preconditions.checkState((partitionColumns.size() == partitionValues.size() ? 1 : 0) != 0, (Object)"Parameters partition_column and partition_value should have same length");
        if (schemaName.isEmpty() && tableName.isEmpty() && partitionColumns.isEmpty()) {
            cachingHiveMetastore.flushCache();
        } else if (schemaName.isPresent() && tableName.isPresent() && !partitionColumns.isEmpty()) {
            cachingHiveMetastore.flushPartitionCache(schemaName.get(), tableName.get(), partitionColumns, partitionValues);
        } else {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Illegal parameter set passed. " + PROCEDURE_USAGE_EXAMPLES);
        }
    }
}

