/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;

public class BridgingHiveMetastore
implements HiveMetastore {
    private final ThriftMetastore delegate;
    private final HiveIdentity identity;

    public BridgingHiveMetastore(ThriftMetastore delegate, HiveIdentity identity) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName).map(ThriftMetastoreUtil::fromMetastoreApiDatabase);
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.delegate.getTable(this.identity, databaseName, tableName).map(table -> {
            if (ThriftMetastoreUtil.isAvroTableWithSchemaSet(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, this.delegate.getFields(this.identity, databaseName, tableName).orElseThrow());
            }
            if (ThriftMetastoreUtil.isCsvTable(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, ThriftMetastoreUtil.csvSchemaFields(table.getSd().getCols()));
            }
            return ThriftMetastoreUtil.fromMetastoreApiTable(table);
        });
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        return this.delegate.getTableStatistics(this.identity, ThriftMetastoreUtil.toMetastoreApiTable(table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        return this.delegate.getPartitionStatistics(this.identity, ThriftMetastoreUtil.toMetastoreApiTable(table), (List)partitions.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updateTableStatistics(this.identity, databaseName, tableName, transaction, update);
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        org.apache.hadoop.hive.metastore.api.Table metastoreTable = ThriftMetastoreUtil.toMetastoreApiTable(table);
        updates.forEach((partitionName, update) -> this.delegate.updatePartitionStatistics(this.identity, metastoreTable, (String)partitionName, (Function<PartitionStatistics, PartitionStatistics>)update));
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        return this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue);
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(this.identity, ThriftMetastoreUtil.toMetastoreApiDatabase(database));
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(this.identity, databaseName, deleteData);
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        org.apache.hadoop.hive.metastore.api.Database database = this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        database.setName(newDatabaseName);
        this.delegate.alterDatabase(this.identity, databaseName, database);
        this.delegate.getDatabase(databaseName).ifPresent(newDatabase -> {
            if (newDatabase.getName().equals(databaseName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive metastore does not support renaming schemas");
            }
        });
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        Database database = ThriftMetastoreUtil.fromMetastoreApiDatabase(this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)));
        Database newDatabase = Database.builder(database).setOwnerName(Optional.of(principal.getName())).setOwnerType(Optional.of(principal.getType())).build();
        this.delegate.alterDatabase(this.identity, databaseName, ThriftMetastoreUtil.toMetastoreApiDatabase(newDatabase));
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(this.identity, ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges));
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(this.identity, databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.alterTable(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable, principalPrivileges));
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(this.identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.setDbName(newDatabaseName);
        table.setTableName(newTableName);
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(this.identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        Map<String, String> parameters = table.getParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        comment.ifPresent(value -> parameters.put("comment", (String)value));
        table.setParameters(parameters);
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(this.delegate.getTable(this.identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName))));
        Table newTable = Table.builder(table).setOwner(Optional.of(principal.getName())).build();
        this.delegate.alterTable(this.identity, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable));
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(this.identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(columnName)) continue;
            if (comment.isPresent()) {
                fieldSchema.setComment(comment.get());
                continue;
            }
            fieldSchema.unsetComment();
        }
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(this.identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.getSd().getCols().add(new FieldSchema(columnName, columnType.getHiveTypeName().toString(), columnComment));
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(this.identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            fieldSchema.setName(newColumnName);
        }
        this.alterTable(databaseName, tableName, table);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        org.apache.hadoop.hive.metastore.api.Table table = this.delegate.getTable(this.identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().removeIf(fieldSchema -> fieldSchema.getName().equals(columnName));
        this.alterTable(databaseName, tableName, table);
    }

    private void alterTable(String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        this.delegate.alterTable(this.identity, databaseName, tableName, table);
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        return this.delegate.getPartition(this.identity, table.getDatabaseName(), table.getTableName(), partitionValues).map(partition -> this.fromMetastoreApiPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.delegate.getPartitionNamesByFilter(this.identity, databaseName, tableName, columnNames, partitionKeysFilter);
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = this.delegate.getPartitionsByNames(this.identity, table.getDatabaseName(), table.getTableName(), partitionNames).stream().map(partition -> this.fromMetastoreApiPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition)).collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition2 = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition2));
        }
        return resultBuilder.buildOrThrow();
    }

    private Partition fromMetastoreApiPartition(Table table, org.apache.hadoop.hive.metastore.api.Partition partition) {
        if (MetastoreUtil.isAvroTableWithSchemaSet(table)) {
            List schema = (List)table.getDataColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList());
            return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, schema);
        }
        return ThriftMetastoreUtil.fromMetastoreApiPartition(partition);
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(this.identity, databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(this.identity, databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(this.identity, databaseName, tableName, partition);
    }

    @Override
    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return this.delegate.listGrantedPrincipals(role);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public long openTransaction() {
        return this.delegate.openTransaction(this.identity);
    }

    @Override
    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(this.identity, transactionId);
    }

    @Override
    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(this.identity, transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(this.identity, transactionId);
    }

    @Override
    public void acquireSharedReadLock(String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(this.identity, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(this.identity, tables, currentTransactionId);
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(this.identity, dbName, tableName, transactionId);
    }

    @Override
    public void acquireTableWriteLock(String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(this.identity, queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite);
    }

    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(this.identity, dbName, tableName, transactionId, writeId, rowCountChange);
    }

    @Override
    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) {
        List hadoopPartitions = (List)partitions.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).peek(partition -> partition.setWriteId(writeId)).collect(ImmutableList.toImmutableList());
        this.delegate.alterPartitions(this.identity, dbName, tableName, hadoopPartitions, writeId);
    }

    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(this.identity, dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        this.delegate.alterTransactionalTable(this.identity, ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges), transactionId, writeId);
    }
}

