/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class BridgingHiveMetastoreFactory
implements HiveMetastoreFactory {
    private final ThriftMetastore thriftMetastore;

    @Inject
    public BridgingHiveMetastoreFactory(ThriftMetastore thriftMetastore) {
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.thriftMetastore.isImpersonationEnabled();
    }

    @Override
    public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
        return new BridgingHiveMetastore(this.thriftMetastore, identity.map(HiveIdentity::new).orElse(HiveIdentity.none()));
    }
}

