/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.ForHiveMetastore;
import io.trino.plugin.hive.HdfsConfigurationInitializer;
import io.trino.plugin.hive.authentication.AuthenticationModules;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.trino.plugin.hive.authentication.MetastoreKerberosConfig;
import io.trino.plugin.hive.metastore.thrift.KerberosHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;

public class ThriftMetastoreAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(this.getAuthenticationModule());
    }

    private Module getAuthenticationModule() {
        ThriftMetastoreAuthenticationConfig.ThriftMetastoreAuthenticationType type = ((ThriftMetastoreAuthenticationConfig)this.buildConfigObject(ThriftMetastoreAuthenticationConfig.class)).getAuthenticationType();
        switch (type) {
            case NONE: {
                return new NoHiveMetastoreAuthenticationModule();
            }
            case KERBEROS: {
                return new KerberosHiveMetastoreAuthenticationModule();
            }
        }
        throw new AssertionError((Object)("Unknown authentication type: " + type));
    }

    public static class KerberosHiveMetastoreAuthenticationModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(HiveMetastoreAuthentication.class).to(KerberosHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreKerberosConfig.class);
        }

        @Provides
        @Singleton
        @ForHiveMetastore
        public HadoopAuthentication createHadoopAuthentication(MetastoreKerberosConfig config, HdfsConfigurationInitializer updater) {
            String principal = config.getHiveMetastoreClientPrincipal();
            String keytabLocation = config.getHiveMetastoreClientKeytab();
            return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
        }
    }

    public static class NoHiveMetastoreAuthenticationModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(HiveMetastoreAuthentication.class).to(NoHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
        }
    }
}

