/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.ConfigurationInitializer;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3AclType;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.plugin.hive.s3.TrinoS3Protocol;
import io.trino.plugin.hive.s3.TrinoS3SignerType;
import io.trino.plugin.hive.s3.TrinoS3SseType;
import io.trino.plugin.hive.s3.TrinoS3StorageClass;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class TrinoS3ConfigurationInitializer
implements ConfigurationInitializer {
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String endpoint;
    private final TrinoS3StorageClass s3StorageClass;
    private final TrinoS3SignerType signerType;
    private final boolean pathStyleAccess;
    private final String iamRole;
    private final String externalId;
    private final boolean sslEnabled;
    private final boolean sseEnabled;
    private final TrinoS3SseType sseType;
    private final String encryptionMaterialsProvider;
    private final String kmsKeyId;
    private final String sseKmsKeyId;
    private final int maxClientRetries;
    private final int maxErrorRetries;
    private final Duration maxBackoffTime;
    private final Duration maxRetryTime;
    private final Duration connectTimeout;
    private final Duration socketTimeout;
    private final int maxConnections;
    private final DataSize multipartMinFileSize;
    private final DataSize multipartMinPartSize;
    private final File stagingDirectory;
    private final boolean pinClientToCurrentRegion;
    private final String userAgentPrefix;
    private final TrinoS3AclType aclType;
    private final String signerClass;
    private final boolean requesterPaysEnabled;
    private final boolean skipGlacierObjects;
    private final boolean s3StreamingUploadEnabled;
    private final DataSize streamingPartSize;
    private final String s3proxyHost;
    private final int s3proxyPort;
    private final TrinoS3Protocol s3ProxyProtocol;
    private final List<String> s3nonProxyHosts;
    private final String s3proxyUsername;
    private final String s3proxyPassword;
    private final boolean s3preemptiveBasicProxyAuth;

    @Inject
    public TrinoS3ConfigurationInitializer(HiveS3Config config) {
        this.awsAccessKey = config.getS3AwsAccessKey();
        this.awsSecretKey = config.getS3AwsSecretKey();
        this.endpoint = config.getS3Endpoint();
        this.s3StorageClass = config.getS3StorageClass();
        this.signerType = config.getS3SignerType();
        this.signerClass = config.getS3SignerClass();
        this.pathStyleAccess = config.isS3PathStyleAccess();
        this.iamRole = config.getS3IamRole();
        this.externalId = config.getS3ExternalId();
        this.sslEnabled = config.isS3SslEnabled();
        this.sseEnabled = config.isS3SseEnabled();
        this.sseType = config.getS3SseType();
        this.encryptionMaterialsProvider = config.getS3EncryptionMaterialsProvider();
        this.kmsKeyId = config.getS3KmsKeyId();
        this.sseKmsKeyId = config.getS3SseKmsKeyId();
        this.maxClientRetries = config.getS3MaxClientRetries();
        this.maxErrorRetries = config.getS3MaxErrorRetries();
        this.maxBackoffTime = config.getS3MaxBackoffTime();
        this.maxRetryTime = config.getS3MaxRetryTime();
        this.connectTimeout = config.getS3ConnectTimeout();
        this.socketTimeout = config.getS3SocketTimeout();
        this.maxConnections = config.getS3MaxConnections();
        this.multipartMinFileSize = config.getS3MultipartMinFileSize();
        this.multipartMinPartSize = config.getS3MultipartMinPartSize();
        this.stagingDirectory = config.getS3StagingDirectory();
        this.pinClientToCurrentRegion = config.isPinS3ClientToCurrentRegion();
        this.userAgentPrefix = config.getS3UserAgentPrefix();
        this.aclType = config.getS3AclType();
        this.skipGlacierObjects = config.isSkipGlacierObjects();
        this.requesterPaysEnabled = config.isRequesterPaysEnabled();
        this.s3StreamingUploadEnabled = config.isS3StreamingUploadEnabled();
        this.streamingPartSize = config.getS3StreamingPartSize();
        this.s3proxyHost = config.getS3ProxyHost();
        this.s3proxyPort = config.getS3ProxyPort();
        this.s3ProxyProtocol = config.getS3ProxyProtocol();
        this.s3nonProxyHosts = config.getS3NonProxyHosts();
        this.s3proxyUsername = config.getS3ProxyUsername();
        this.s3proxyPassword = config.getS3ProxyPassword();
        this.s3preemptiveBasicProxyAuth = config.getS3PreemptiveBasicProxyAuth();
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        config.set("fs.s3.impl", TrinoS3FileSystem.class.getName());
        config.set("fs.s3a.impl", TrinoS3FileSystem.class.getName());
        config.set("fs.s3n.impl", TrinoS3FileSystem.class.getName());
        if (this.awsAccessKey != null) {
            config.set("trino.s3.access-key", this.awsAccessKey);
        }
        if (this.awsSecretKey != null) {
            config.set("trino.s3.secret-key", this.awsSecretKey);
        }
        if (this.endpoint != null) {
            config.set("trino.s3.endpoint", this.endpoint);
        }
        config.set("trino.s3.storage-class", this.s3StorageClass.name());
        if (this.signerType != null) {
            config.set("trino.s3.signer-type", this.signerType.name());
        }
        if (this.signerClass != null) {
            config.set("trino.s3.signer-class", this.signerClass);
        }
        config.setBoolean("trino.s3.path-style-access", this.pathStyleAccess);
        if (this.iamRole != null) {
            config.set("trino.s3.iam-role", this.iamRole);
        }
        if (this.externalId != null) {
            config.set("trino.s3.external-id", this.externalId);
        }
        config.setBoolean("trino.s3.ssl.enabled", this.sslEnabled);
        config.setBoolean("trino.s3.sse.enabled", this.sseEnabled);
        config.set("trino.s3.sse.type", this.sseType.name());
        if (this.encryptionMaterialsProvider != null) {
            config.set("trino.s3.encryption-materials-provider", this.encryptionMaterialsProvider);
        }
        if (this.kmsKeyId != null) {
            config.set("trino.s3.kms-key-id", this.kmsKeyId);
        }
        if (this.sseKmsKeyId != null) {
            config.set("trino.s3.sse.kms-key-id", this.sseKmsKeyId);
        }
        config.setInt("trino.s3.max-client-retries", this.maxClientRetries);
        config.setInt("trino.s3.max-error-retries", this.maxErrorRetries);
        config.set("trino.s3.max-backoff-time", this.maxBackoffTime.toString());
        config.set("trino.s3.max-retry-time", this.maxRetryTime.toString());
        config.set("trino.s3.connect-timeout", this.connectTimeout.toString());
        config.set("trino.s3.socket-timeout", this.socketTimeout.toString());
        config.set("trino.s3.staging-directory", this.stagingDirectory.getPath());
        config.setInt("trino.s3.max-connections", this.maxConnections);
        config.setLong("trino.s3.multipart.min-file-size", this.multipartMinFileSize.toBytes());
        config.setLong("trino.s3.multipart.min-part-size", this.multipartMinPartSize.toBytes());
        config.setBoolean("trino.s3.pin-client-to-current-region", this.pinClientToCurrentRegion);
        config.set("trino.s3.user-agent-prefix", this.userAgentPrefix);
        config.set("trino.s3.upload-acl-type", this.aclType.name());
        config.setBoolean("trino.s3.skip-glacier-objects", this.skipGlacierObjects);
        config.setBoolean("trino.s3.requester-pays.enabled", this.requesterPaysEnabled);
        config.setBoolean("trino.s3.streaming.enabled", this.s3StreamingUploadEnabled);
        config.setLong("trino.s3.streaming.part-size", this.streamingPartSize.toBytes());
        if (this.s3proxyHost != null) {
            config.set("trino.s3.proxy.host", this.s3proxyHost);
        }
        if (this.s3proxyPort > -1) {
            config.setInt("trino.s3.proxy.port", this.s3proxyPort);
        }
        if (this.s3ProxyProtocol != null) {
            config.set("trino.s3.proxy.protocol", this.s3ProxyProtocol.name());
        }
        if (this.s3nonProxyHosts != null) {
            config.set("trino.s3.proxy.non-proxy-hosts", this.s3nonProxyHosts.stream().collect(Collectors.joining("|")));
        }
        if (this.s3proxyUsername != null) {
            config.set("trino.s3.proxy.username", this.s3proxyUsername);
        }
        if (this.s3proxyPassword != null) {
            config.set("trino.s3.proxy.password", this.s3proxyPassword);
        }
        config.setBoolean("trino.s3.proxy.preemptive-basic-auth", this.s3preemptiveBasicProxyAuth);
    }
}

