/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import io.airlift.units.Duration;
import io.trino.plugin.hive.aws.AbstractSdkMetricsCollector;
import io.trino.plugin.hive.s3.TrinoS3FileSystemStats;
import java.util.Objects;

public class TrinoS3FileSystemMetricCollector
extends AbstractSdkMetricsCollector {
    private final TrinoS3FileSystemStats stats;

    public TrinoS3FileSystemMetricCollector(TrinoS3FileSystemStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    protected void recordRequestCount(long count) {
        this.stats.updateAwsRequestCount(count);
    }

    @Override
    protected void recordRetryCount(long count) {
        this.stats.updateAwsRetryCount(count);
    }

    @Override
    protected void recordThrottleExceptionCount(long count) {
        this.stats.updateAwsThrottleExceptionsCount(count);
    }

    @Override
    protected void recordHttpRequestTime(Duration duration) {
        this.stats.addAwsRequestTime(duration);
    }

    @Override
    protected void recordClientExecutionTime(Duration duration) {
        this.stats.addAwsClientExecuteTime(duration);
    }

    @Override
    protected void recordRetryPauseTime(Duration duration) {
        this.stats.addAwsClientRetryPauseTime(duration);
    }

    @Override
    protected void recordHttpClientPoolAvailableCount(long count) {
        this.stats.setAwsHttpClientPoolAvailableCount(count);
    }

    @Override
    protected void recordHttpClientPoolLeasedCount(long count) {
        this.stats.setAwsHttpClientPoolLeasedCount(count);
    }

    @Override
    protected void recordHttpClientPoolPendingCount(long count) {
        this.stats.setAwsHttpClientPoolPendingCount(count);
    }
}

