/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.linkedin.coral.common.HiveSchema;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;

public class HiveSchemaUtils {
    private HiveSchemaUtils() {
    }

    public static Optional<Schema> getDb(@Nonnull HiveSchema schema, @Nonnull String db) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)schema);
        return Optional.ofNullable(schema.getSubSchema(db));
    }

    public static Optional<Table> getTable(@Nonnull HiveSchema schema, @Nonnull String db, @Nonnull String table) {
        Preconditions.checkNotNull((Object)table);
        Optional<Schema> dbSchema = HiveSchemaUtils.getDb(schema, db);
        return dbSchema.map(value -> value.getTable(table));
    }
}

