/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.linkedin.coral.com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.base.Throwables;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.HiveTable;
import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveViewTable
extends HiveTable
implements TranslatableTable {
    private final List<String> schemaPath;

    public HiveViewTable(Table hiveTable, List<String> schemaPath) {
        super(hiveTable);
        this.schemaPath = schemaPath;
    }

    public RelNode toRel(RelOptTable.ToRelContext relContext, RelOptTable relOptTable) {
        try {
            RelRoot root = relContext.expandView(relOptTable.getRowType(), this.hiveTable.getViewExpandedText(), this.schemaPath, (List)ImmutableList.of((Object)this.hiveTable.getTableName()));
            root = root.withRel(HiveViewTable.createCastRel(root.rel, relOptTable.getRowType(), RelFactories.DEFAULT_PROJECT_FACTORY));
            return root.rel;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, RuntimeException.class);
            throw new RuntimeException("Error while parsing view definition", e);
        }
    }

    public static RelNode createCastRel(RelNode rel, RelDataType castRowType, RelFactories.ProjectFactory projectFactory) {
        Preconditions.checkNotNull((Object)projectFactory);
        RelDataType rowType = rel.getRowType();
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        if (HiveViewTable.isRowCastRequired(rowType, castRowType, typeFactory)) {
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            List castExps = RexUtil.generateCastExpressions((RexBuilder)rexBuilder, (RelDataType)castRowType, (RelDataType)rowType);
            return projectFactory.createProject(rel, castExps, rowType.getFieldNames());
        }
        return rel;
    }

    private static boolean isRowCastRequired(RelDataType rowType, RelDataType castRowType, RelDataTypeFactory typeFactory) {
        if (rowType == castRowType) {
            return false;
        }
        List relFields = rowType.getFieldList();
        List castFields = castRowType.getFieldList();
        if (relFields.size() != castFields.size()) {
            return true;
        }
        return HiveViewTable.isFieldListCastRequired(relFields, castFields, typeFactory);
    }

    private static boolean isTypeCastRequired(RelDataType inputType, RelDataType castToType, RelDataTypeFactory typeFactory) {
        if (inputType == castToType) {
            return false;
        }
        if (inputType.getSqlTypeName() == SqlTypeName.ANY || castToType.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if ((inputType.getSqlTypeName() == SqlTypeName.CHAR || inputType.getSqlTypeName() == SqlTypeName.VARCHAR) && castToType.getSqlTypeName() == SqlTypeName.VARCHAR) {
            return false;
        }
        if (inputType.getSqlTypeName() != castToType.getSqlTypeName()) {
            return true;
        }
        RelDataType nullableFieldDataType = typeFactory.createTypeWithNullability(inputType, true);
        switch (inputType.getSqlTypeName()) {
            case ARRAY: {
                return HiveViewTable.isTypeCastRequired(inputType.getComponentType(), castToType.getComponentType(), typeFactory);
            }
            case MAP: {
                return HiveViewTable.isTypeCastRequired(inputType.getKeyType(), castToType.getKeyType(), typeFactory) || HiveViewTable.isTypeCastRequired(inputType.getValueType(), inputType.getValueType(), typeFactory);
            }
            case ROW: {
                return HiveViewTable.isFieldListCastRequired(inputType.getFieldList(), castToType.getFieldList(), typeFactory);
            }
        }
        return !nullableFieldDataType.equals(castToType);
    }

    private static boolean isFieldListCastRequired(List<RelDataTypeField> inputFields, List<RelDataTypeField> castToFields, RelDataTypeFactory typeFactory) {
        if (inputFields.size() < castToFields.size()) {
            return true;
        }
        int inputIndex = 0;
        int inputFieldsSize = inputFields.size();
        for (RelDataTypeField castToField : castToFields) {
            while (inputIndex < inputFieldsSize) {
                RelDataTypeField inputField = inputFields.get(inputIndex);
                if (inputField.getName().equalsIgnoreCase(castToField.getName())) {
                    if (!HiveViewTable.isTypeCastRequired(inputField.getType(), castToField.getType(), typeFactory)) break;
                    return true;
                }
                ++inputIndex;
            }
            if (inputIndex++ < inputFieldsSize) continue;
            return true;
        }
        return false;
    }
}

