/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class TypeConverter {
    private TypeConverter() {
    }

    public static RelDataType convert(TypeInfo typeInfo, RelDataTypeFactory relTypeFactory) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return TypeConverter.convert((PrimitiveTypeInfo)typeInfo, relTypeFactory);
            }
            case LIST: {
                return TypeConverter.convert((ListTypeInfo)typeInfo, relTypeFactory);
            }
            case MAP: {
                return TypeConverter.convert((MapTypeInfo)typeInfo, relTypeFactory);
            }
            case STRUCT: {
                return TypeConverter.convert((StructTypeInfo)typeInfo, relTypeFactory);
            }
            case UNION: {
                return TypeConverter.convert((UnionTypeInfo)typeInfo, relTypeFactory);
            }
        }
        throw new RuntimeException("Unknown type category: " + typeInfo.getCategory());
    }

    public static RelDataType convert(PrimitiveTypeInfo type, RelDataTypeFactory dtFactory) {
        RelDataType convertedType = null;
        switch (type.getPrimitiveCategory()) {
            case VOID: {
                convertedType = dtFactory.createSqlType(SqlTypeName.NULL);
                break;
            }
            case BOOLEAN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case BYTE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TINYINT);
                break;
            }
            case SHORT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.SMALLINT);
                break;
            }
            case INT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.INTEGER);
                break;
            }
            case LONG: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case FLOAT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.FLOAT);
                break;
            }
            case DOUBLE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case STRING: {
                convertedType = dtFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE);
                break;
            }
            case DATE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DATE);
                break;
            }
            case TIMESTAMP: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            case BINARY: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BINARY);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo dtInf = (DecimalTypeInfo)type;
                convertedType = dtFactory.createSqlType(SqlTypeName.DECIMAL, dtInf.precision(), dtInf.scale());
                break;
            }
            case VARCHAR: {
                convertedType = dtFactory.createSqlType(SqlTypeName.VARCHAR, ((BaseCharTypeInfo)type).getLength());
                break;
            }
            case CHAR: {
                convertedType = dtFactory.createSqlType(SqlTypeName.CHAR, ((BaseCharTypeInfo)type).getLength());
                break;
            }
            case UNKNOWN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.OTHER);
                break;
            }
            default: {
                throw new RuntimeException("Unknown primitive type category: " + type.getPrimitiveCategory());
            }
        }
        if (null == convertedType) {
            throw new RuntimeException("Unsupported Type : " + type.getTypeName());
        }
        return dtFactory.createTypeWithNullability(convertedType, true);
    }

    public static RelDataType convert(ListTypeInfo lstType, RelDataTypeFactory dtFactory) {
        RelDataType elemType = TypeConverter.convert(lstType.getListElementTypeInfo(), dtFactory);
        RelDataType arrayType = dtFactory.createArrayType(elemType, -1L);
        return dtFactory.createTypeWithNullability(arrayType, true);
    }

    public static RelDataType convert(MapTypeInfo mapType, RelDataTypeFactory dtFactory) {
        RelDataType keyType = TypeConverter.convert(mapType.getMapKeyTypeInfo(), dtFactory);
        RelDataType valueType = TypeConverter.convert(mapType.getMapValueTypeInfo(), dtFactory);
        RelDataType type = dtFactory.createMapType(keyType, valueType);
        return dtFactory.createTypeWithNullability(type, true);
    }

    public static RelDataType convert(StructTypeInfo structType, RelDataTypeFactory dtFactory) {
        ArrayList<RelDataType> fTypes = new ArrayList<RelDataType>(structType.getAllStructFieldTypeInfos().size());
        for (TypeInfo ti : structType.getAllStructFieldTypeInfos()) {
            fTypes.add(TypeConverter.convert(ti, dtFactory));
        }
        RelDataType rowType = dtFactory.createStructType(fTypes, (List)structType.getAllStructFieldNames());
        return dtFactory.createTypeWithNullability(rowType, true);
    }

    public static RelDataType convert(UnionTypeInfo unionType, RelDataTypeFactory dtFactory) {
        List fTypes = unionType.getAllUnionObjectTypeInfos().stream().map(typeInfo -> TypeConverter.convert(typeInfo, dtFactory)).collect(Collectors.toList());
        List fNames = IntStream.range(0, unionType.getAllUnionObjectTypeInfos().size()).mapToObj(i -> "field" + i).collect(Collectors.toList());
        fTypes.add(0, dtFactory.createSqlType(SqlTypeName.INTEGER));
        fNames.add(0, "tag");
        RelDataType rowType = dtFactory.createStructType(fTypes, fNames);
        return dtFactory.createTypeWithNullability(rowType, true);
    }

    public static TypeInfo convert(RelDataType rType) {
        if (rType.isStruct()) {
            return TypeConverter.convertStructType(rType);
        }
        if (rType.getComponentType() != null) {
            return TypeConverter.convertListType(rType);
        }
        if (rType.getKeyType() != null) {
            return TypeConverter.convertMapType(rType);
        }
        return TypeConverter.convertPrimtiveType(rType);
    }

    public static TypeInfo convertStructType(RelDataType rType) {
        List fTypes = rType.getFieldList().stream().map(f -> TypeConverter.convert(f.getType())).collect(Collectors.toList());
        List fNames = rType.getFieldNames();
        return TypeInfoFactory.getStructTypeInfo((List)fNames, fTypes);
    }

    public static TypeInfo convertMapType(RelDataType rType) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeConverter.convert(rType.getKeyType()), (TypeInfo)TypeConverter.convert(rType.getValueType()));
    }

    public static TypeInfo convertListType(RelDataType rType) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)TypeConverter.convert(rType.getComponentType()));
    }

    public static TypeInfo convertPrimtiveType(RelDataType rType) {
        switch (rType.getSqlTypeName()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case BINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DECIMAL: {
                return TypeInfoFactory.getDecimalTypeInfo((int)rType.getPrecision(), (int)rType.getScale());
            }
            case VARCHAR: {
                if (rType.getPrecision() == Integer.MAX_VALUE) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)rType.getPrecision());
            }
            case CHAR: {
                if (rType.getPrecision() > 255) {
                    return TypeInfoFactory.getVarcharTypeInfo((int)rType.getPrecision());
                }
                return TypeInfoFactory.getCharTypeInfo((int)rType.getPrecision());
            }
        }
        return TypeInfoFactory.voidTypeInfo;
    }
}

