/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.openjdk.jol.info.ClassLayout;

public class HiveSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveSplit.class).instanceSize();
    private final String path;
    private final long start;
    private final long length;
    private final long estimatedFileSize;
    private final long fileModifiedTime;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String database;
    private final String table;
    private final String partitionName;
    private final OptionalInt bucketNumber;
    private final int statementId;
    private final boolean forceLocalScheduling;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<BucketConversion> bucketConversion;
    private final Optional<BucketValidation> bucketValidation;
    private final boolean s3SelectPushdownEnabled;
    private final Optional<AcidInfo> acidInfo;
    private final long splitNumber;
    private final SplitWeight splitWeight;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="estimatedFileSize") long estimatedFileSize, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="schema") Properties schema, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="forceLocalScheduling") boolean forceLocalScheduling, @JsonProperty(value="tableToPartitionMapping") TableToPartitionMapping tableToPartitionMapping, @JsonProperty(value="bucketConversion") Optional<BucketConversion> bucketConversion, @JsonProperty(value="bucketValidation") Optional<BucketValidation> bucketValidation, @JsonProperty(value="s3SelectPushdownEnabled") boolean s3SelectPushdownEnabled, @JsonProperty(value="acidInfo") Optional<AcidInfo> acidInfo, @JsonProperty(value="splitNumber") long splitNumber, @JsonProperty(value="splitWeight") SplitWeight splitWeight) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((estimatedFileSize >= 0L ? 1 : 0) != 0, (Object)"estimatedFileSize must be positive");
        Objects.requireNonNull(database, "database is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(bucketValidation, "bucketValidation is null");
        Objects.requireNonNull(acidInfo, "acidInfo is null");
        this.database = database;
        this.table = table;
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.estimatedFileSize = estimatedFileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.bucketNumber = bucketNumber;
        this.statementId = statementId;
        this.forceLocalScheduling = forceLocalScheduling;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.bucketValidation = bucketValidation;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.acidInfo = acidInfo;
        this.splitNumber = splitNumber;
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getEstimatedFileSize() {
        return this.estimatedFileSize;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public Properties getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public int getStatementId() {
        return this.statementId;
    }

    @JsonProperty
    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @JsonProperty
    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    @JsonProperty
    public Optional<BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    @JsonProperty
    public Optional<BucketValidation> getBucketValidation() {
        return this.bucketValidation;
    }

    public boolean isRemotelyAccessible() {
        return !this.forceLocalScheduling;
    }

    @JsonProperty
    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @JsonProperty
    public Optional<AcidInfo> getAcidInfo() {
        return this.acidInfo;
    }

    @JsonProperty
    public long getSplitNumber() {
        return this.splitNumber;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf((Map)this.schema, key -> SizeOf.estimatedSizeOf((String)((String)key)), value -> SizeOf.estimatedSizeOf((String)((String)value))) + SizeOf.estimatedSizeOf(this.partitionKeys, HivePartitionKey::getEstimatedSizeInBytes) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.database) + SizeOf.estimatedSizeOf((String)this.table) + SizeOf.estimatedSizeOf((String)this.partitionName) + SizeOf.sizeOf((OptionalInt)this.bucketNumber) + (long)this.tableToPartitionMapping.getEstimatedSizeInBytes() + SizeOf.sizeOf(this.bucketConversion, BucketConversion::getRetainedSizeInBytes) + SizeOf.sizeOf(this.bucketValidation, BucketValidation::getRetainedSizeInBytes) + SizeOf.sizeOf(this.acidInfo, AcidInfo::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes();
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).put((Object)"estimatedFileSize", (Object)this.estimatedFileSize).put((Object)"hosts", this.addresses).put((Object)"database", (Object)this.database).put((Object)"table", (Object)this.table).put((Object)"forceLocalScheduling", (Object)this.forceLocalScheduling).put((Object)"partitionName", (Object)this.partitionName).put((Object)"deserializerClassName", (Object)HiveUtil.getDeserializerClassName(this.schema)).put((Object)"s3SelectPushdownEnabled", (Object)this.s3SelectPushdownEnabled).put((Object)"splitNumber", (Object)this.splitNumber).buildOrThrow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).addValue(this.estimatedFileSize).toString();
    }

    public static class BucketValidation {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(BucketValidation.class).instanceSize();
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketCount;
        private final List<HiveColumnHandle> bucketColumns;

        @JsonCreator
        public BucketValidation(@JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="bucketColumns") List<HiveColumnHandle> bucketColumns) {
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.bucketCount = bucketCount;
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
        }

        @JsonProperty
        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        @JsonProperty
        public int getBucketCount() {
            return this.bucketCount;
        }

        @JsonProperty
        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.bucketColumns, HiveColumnHandle::getRetainedSizeInBytes);
        }
    }

    public static class BucketConversion {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(BucketConversion.class).instanceSize();
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<HiveColumnHandle> bucketColumnNames;

        @JsonCreator
        public BucketConversion(@JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="partitionBucketCount") int partitionBucketCount, @JsonProperty(value="bucketColumnHandles") List<HiveColumnHandle> bucketColumnHandles) {
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketColumnNames = Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null");
        }

        @JsonProperty
        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        @JsonProperty
        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        @JsonProperty
        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        @JsonProperty
        public List<HiveColumnHandle> getBucketColumnHandles() {
            return this.bucketColumnNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketConversion that = (BucketConversion)o;
            return this.tableBucketCount == that.tableBucketCount && this.partitionBucketCount == that.partitionBucketCount && Objects.equals(this.bucketColumnNames, that.bucketColumnNames);
        }

        public int hashCode() {
            return Objects.hash(this.tableBucketCount, this.partitionBucketCount, this.bucketColumnNames);
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.bucketColumnNames, HiveColumnHandle::getRetainedSizeInBytes);
        }
    }
}

