/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.OpenCSVSerde;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.data.JsonSerDe;

public enum HiveStorageFormat {
    ORC(OrcSerde.class.getName(), OrcInputFormat.class.getName(), OrcOutputFormat.class.getName(), DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    PARQUET(ParquetHiveSerDe.class.getName(), MapredParquetInputFormat.class.getName(), MapredParquetOutputFormat.class.getName(), DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    AVRO(AvroSerDe.class.getName(), AvroContainerInputFormat.class.getName(), AvroContainerOutputFormat.class.getName(), DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCBINARY(LazyBinaryColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCTEXT(ColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    SEQUENCEFILE(LazySimpleSerDe.class.getName(), SequenceFileInputFormat.class.getName(), HiveSequenceFileOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    JSON(JsonSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    TEXTFILE(LazySimpleSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    CSV(OpenCSVSerde.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName(), DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterMemoryUsage;
    private static final Map<SerdeAndInputFormat, HiveStorageFormat> HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterMemoryUsage = Objects.requireNonNull(estimatedWriterMemoryUsage, "estimatedWriterMemoryUsage is null");
    }

    public String getSerde() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterMemoryUsage() {
        return this.estimatedWriterMemoryUsage;
    }

    public void validateColumns(List<HiveColumnHandle> handles) {
        if (this == AVRO) {
            for (HiveColumnHandle handle : handles) {
                if (handle.isPartitionKey()) continue;
                HiveStorageFormat.validateAvroType(handle.getHiveType().getTypeInfo(), handle.getName());
            }
        }
    }

    private static void validateAvroType(TypeInfo type, String columnName) {
        if (type.getCategory() == ObjectInspector.Category.MAP) {
            TypeInfo keyType = HiveStorageFormat.mapTypeInfo(type).getMapKeyTypeInfo();
            if (keyType.getCategory() != ObjectInspector.Category.PRIMITIVE || HiveStorageFormat.primitiveTypeInfo(keyType).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' has a non-varchar map key, which is not supported by Avro", columnName));
            }
        } else if (type.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory primitive = HiveStorageFormat.primitiveTypeInfo(type).getPrimitiveCategory();
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.BYTE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is tinyint, which is not supported by Avro. Use integer instead.", columnName));
            }
            if (primitive == PrimitiveObjectInspector.PrimitiveCategory.SHORT) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is smallint, which is not supported by Avro. Use integer instead.", columnName));
            }
        }
    }

    public static Optional<HiveStorageFormat> getHiveStorageFormat(StorageFormat storageFormat) {
        return Optional.ofNullable(HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT.get(new SerdeAndInputFormat(storageFormat.getSerde(), storageFormat.getInputFormat())));
    }

    private static PrimitiveTypeInfo primitiveTypeInfo(TypeInfo typeInfo) {
        return (PrimitiveTypeInfo)typeInfo;
    }

    private static MapTypeInfo mapTypeInfo(TypeInfo typeInfo) {
        return (MapTypeInfo)typeInfo;
    }

    static {
        HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT = (Map)Arrays.stream(HiveStorageFormat.values()).collect(ImmutableMap.toImmutableMap(format -> new SerdeAndInputFormat(format.getSerde(), format.getInputFormat()), (Function)Functions.identity()));
    }

    private static final class SerdeAndInputFormat {
        private final String serde;
        private final String inputFormat;

        public SerdeAndInputFormat(String serde, String inputFormat) {
            this.serde = serde;
            this.inputFormat = inputFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerdeAndInputFormat that = (SerdeAndInputFormat)o;
            return this.serde.equals(that.serde) && this.inputFormat.equals(that.inputFormat);
        }

        public int hashCode() {
            return Objects.hash(this.serde, this.inputFormat);
        }
    }
}

