/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IntegerStatistics {
    private final OptionalLong min;
    private final OptionalLong max;

    @JsonCreator
    public IntegerStatistics(@JsonProperty(value="min") OptionalLong min, @JsonProperty(value="max") OptionalLong max) {
        this.min = Objects.requireNonNull(min, "min is null");
        this.max = Objects.requireNonNull(max, "max is null");
    }

    @JsonProperty
    public OptionalLong getMin() {
        return this.min;
    }

    @JsonProperty
    public OptionalLong getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerStatistics that = (IntegerStatistics)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }
}

