/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public final class DecimalUtils {
    private DecimalUtils() {
    }

    public static long getShortDecimalValue(HiveDecimalWritable writable, int columnScale) {
        byte[] bytes = writable.getInternalStorage();
        long value = DecimalUtils.getShortDecimalValue(bytes);
        value = Decimals.rescale((long)value, (int)writable.getScale(), (int)columnScale);
        return value;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        int i;
        long value = 0L;
        if ((bytes[0] & 0x80) != 0) {
            for (i = 0; i < 8 - bytes.length; ++i) {
                value |= 255L << 8 * (7 - i);
            }
        }
        for (i = 0; i < bytes.length; ++i) {
            value |= ((long)bytes[bytes.length - i - 1] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static Int128 getLongDecimalValue(HiveDecimalWritable writable, int columnScale) {
        Int128 value = Int128.fromBigEndian((byte[])writable.getInternalStorage());
        return Int128Math.rescale((Int128)value, (int)(columnScale - writable.getScale()));
    }
}

