/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final String allocationId;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final ThreadPool threadPool;
    private final Engine.Warmer warmer;
    private final Store store;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    @Nullable
    private final List<ReferenceManager.RefreshListener> refreshListeners;
    @Nullable
    private final Sort indexSort;
    private final boolean forceNewHistoryUUID;
    private final TranslogRecoveryRunner translogRecoveryRunner;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", "default", s -> {
        switch (s) {
            case "default": 
            case "best_compression": 
            case "lucene_default": {
                return s;
            }
        }
        if (!Codec.availableCodecs().contains(s)) {
            throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression] but was: " + s);
        }
        return s;
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDEX_OPTIMIZE_AUTO_GENERATED_IDS = Setting.boolSetting("index.optimize_auto_generated_id", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    private final TranslogConfig translogConfig;
    private final OpenMode openMode;

    public EngineConfig(OpenMode openMode, ShardId shardId, String allocationId, ThreadPool threadPool, IndexSettings indexSettings, Engine.Warmer warmer, Store store, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean forceNewHistoryUUID, TranslogConfig translogConfig, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> refreshListeners, Sort indexSort, TranslogRecoveryRunner translogRecoveryRunner) {
        if (openMode == null) {
            throw new IllegalArgumentException("openMode must not be null");
        }
        this.shardId = shardId;
        this.allocationId = allocationId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.warmer = warmer == null ? a -> {} : warmer;
        this.store = store;
        this.mergePolicy = mergePolicy;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecService = codecService;
        this.eventListener = eventListener;
        this.codecName = indexSettings.getValue(INDEX_CODEC_SETTING);
        this.indexingBufferSize = new ByteSizeValue(256L, ByteSizeUnit.MB);
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
        this.flushMergesAfter = flushMergesAfter;
        this.openMode = openMode;
        this.forceNewHistoryUUID = forceNewHistoryUUID;
        this.refreshListeners = refreshListeners;
        this.indexSort = indexSort;
        this.translogRecoveryRunner = translogRecoveryRunner;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Engine.Warmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public boolean getForceNewHistoryUUID() {
        return this.forceNewHistoryUUID;
    }

    public TranslogRecoveryRunner getTranslogRecoveryRunner() {
        return this.translogRecoveryRunner;
    }

    public List<ReferenceManager.RefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    public boolean isAutoGeneratedIDsOptimizationEnabled() {
        return this.indexSettings.getValue(INDEX_OPTIMIZE_AUTO_GENERATED_IDS);
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    public static enum OpenMode {
        CREATE_INDEX_AND_TRANSLOG,
        OPEN_INDEX_CREATE_TRANSLOG,
        OPEN_INDEX_AND_TRANSLOG;

    }

    @FunctionalInterface
    public static interface TranslogRecoveryRunner {
        public int run(Engine var1, Translog.Snapshot var2) throws IOException;
    }
}

