/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogSnapshot;

final class MultiSnapshot
implements Translog.Snapshot {
    private final TranslogSnapshot[] translogs;
    private final int totalOperations;
    private final Closeable onClose;
    private int index;

    MultiSnapshot(TranslogSnapshot[] translogs, Closeable onClose) {
        this.translogs = translogs;
        this.totalOperations = Arrays.stream(translogs).mapToInt(TranslogSnapshot::totalOperations).sum();
        this.onClose = onClose;
        this.index = 0;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public Translog.Operation next() throws IOException {
        while (this.index < this.translogs.length) {
            TranslogSnapshot current = this.translogs[this.index];
            Translog.Operation op = current.next();
            if (op != null) {
                return op;
            }
            ++this.index;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.onClose.close();
    }
}

