/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.binary;

import io.trino.rcfile.ColumnEncoding;
import io.trino.rcfile.RcFileEncoding;
import io.trino.rcfile.binary.BinaryColumnEncoding;
import io.trino.rcfile.binary.BinaryEncoding;
import io.trino.rcfile.binary.BooleanEncoding;
import io.trino.rcfile.binary.ByteEncoding;
import io.trino.rcfile.binary.DateEncoding;
import io.trino.rcfile.binary.DecimalEncoding;
import io.trino.rcfile.binary.DoubleEncoding;
import io.trino.rcfile.binary.FloatEncoding;
import io.trino.rcfile.binary.ListEncoding;
import io.trino.rcfile.binary.LongEncoding;
import io.trino.rcfile.binary.MapEncoding;
import io.trino.rcfile.binary.ShortEncoding;
import io.trino.rcfile.binary.StringEncoding;
import io.trino.rcfile.binary.StructEncoding;
import io.trino.rcfile.binary.TimestampEncoding;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class BinaryRcFileEncoding
implements RcFileEncoding {
    private final DateTimeZone timeZone;

    public BinaryRcFileEncoding(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public ColumnEncoding booleanEncoding(Type type) {
        return new BooleanEncoding(type);
    }

    @Override
    public ColumnEncoding byteEncoding(Type type) {
        return new ByteEncoding(type);
    }

    @Override
    public ColumnEncoding shortEncoding(Type type) {
        return new ShortEncoding(type);
    }

    @Override
    public ColumnEncoding intEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding longEncoding(Type type) {
        return new LongEncoding(type);
    }

    @Override
    public ColumnEncoding decimalEncoding(Type type) {
        return new DecimalEncoding(type);
    }

    @Override
    public ColumnEncoding floatEncoding(Type type) {
        return new FloatEncoding(type);
    }

    @Override
    public ColumnEncoding doubleEncoding(Type type) {
        return new DoubleEncoding(type);
    }

    @Override
    public ColumnEncoding stringEncoding(Type type) {
        return new StringEncoding(type);
    }

    @Override
    public ColumnEncoding binaryEncoding(Type type) {
        return new BinaryEncoding(type);
    }

    @Override
    public ColumnEncoding dateEncoding(Type type) {
        return new DateEncoding(type);
    }

    @Override
    public ColumnEncoding timestampEncoding(TimestampType type) {
        return new TimestampEncoding(type, this.timeZone);
    }

    @Override
    public ColumnEncoding listEncoding(Type type, ColumnEncoding elementEncoding) {
        return new ListEncoding(type, (BinaryColumnEncoding)elementEncoding);
    }

    @Override
    public ColumnEncoding mapEncoding(Type type, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding) {
        return new MapEncoding(type, (BinaryColumnEncoding)keyEncoding, (BinaryColumnEncoding)valueEncoding);
    }

    @Override
    public ColumnEncoding structEncoding(Type type, List<ColumnEncoding> fieldEncodings) {
        return new StructEncoding(type, fieldEncodings.stream().map(field -> (BinaryColumnEncoding)field).collect(Collectors.toList()));
    }
}

