/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class PinotColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type dataType;
    private final String expression;
    private final boolean aliased;
    private final boolean aggregate;
    private final boolean returnNullOnEmptyGroup;
    private final Optional<String> pushedDownAggregateFunctionName;
    private final Optional<String> pushedDownAggregateFunctionArgument;

    public PinotColumnHandle(String columnName, Type dataType) {
        this(columnName, dataType, columnName, false, false, true, Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public PinotColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="dataType") Type dataType, @JsonProperty(value="expression") String expression, @JsonProperty(value="aliased") boolean aliased, @JsonProperty(value="aggregate") boolean aggregate, @JsonProperty(value="returnNullOnEmptyGroup") boolean returnNullOnEmptyGroup, @JsonProperty(value="pushedDownAggregateFunctionName") Optional<String> pushedDownAggregateFunctionName, @JsonProperty(value="pushedDownAggregateFunctionArgument") Optional<String> pushedDownAggregateFunctionArgument) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.aliased = aliased;
        this.aggregate = aggregate;
        this.returnNullOnEmptyGroup = returnNullOnEmptyGroup;
        Objects.requireNonNull(pushedDownAggregateFunctionName, "pushedDownaAggregateFunctionName is null");
        Objects.requireNonNull(pushedDownAggregateFunctionArgument, "pushedDownaAggregateFunctionArgument is null");
        Preconditions.checkState((pushedDownAggregateFunctionName.isPresent() == pushedDownAggregateFunctionArgument.isPresent() ? 1 : 0) != 0, (Object)"Unexpected arguments: Either pushedDownaAggregateFunctionName and pushedDownaAggregateFunctionArgument must both be present or both be empty.");
        Preconditions.checkState((pushedDownAggregateFunctionName.isPresent() && aggregate || pushedDownAggregateFunctionName.isEmpty() ? 1 : 0) != 0, (Object)"Unexpected arguments: aggregate is false but pushed down aggregation is present");
        this.pushedDownAggregateFunctionName = pushedDownAggregateFunctionName;
        this.pushedDownAggregateFunctionArgument = pushedDownAggregateFunctionArgument;
    }

    public static PinotColumnHandle fromNonAggregateColumnHandle(PinotColumnHandle columnHandle) {
        return new PinotColumnHandle(columnHandle.getColumnName(), columnHandle.getDataType(), DynamicTablePqlExtractor.quoteIdentifier(columnHandle.getColumnName()), false, false, true, Optional.empty(), Optional.empty());
    }

    public static List<PinotColumnHandle> getPinotColumnsForPinotSchema(Schema pinotTableSchema) {
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> new PinotColumnHandle((String)columnName, PinotColumnHandle.getTrinoTypeFromPinotType(pinotTableSchema.getFieldSpecFor(columnName)))).collect(ImmutableList.toImmutableList());
    }

    public static Type getTrinoTypeFromPinotType(FieldSpec field) {
        Type type = PinotColumnHandle.getTrinoTypeFromPinotType(field.getDataType());
        if (field.isSingleValueField()) {
            return type;
        }
        return new ArrayType(type);
    }

    public static Type getTrinoTypeFromPinotType(TransformResultMetadata transformResultMetadata) {
        Type type = PinotColumnHandle.getTrinoTypeFromPinotType(transformResultMetadata.getDataType());
        if (transformResultMetadata.isSingleValue()) {
            return type;
        }
        return new ArrayType(type);
    }

    public static Type getTrinoTypeFromPinotType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported type conversion for pinot data type: " + dataType);
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getDataType() {
        return this.dataType;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty
    public boolean isAliased() {
        return this.aliased;
    }

    @JsonProperty
    public boolean isAggregate() {
        return this.aggregate;
    }

    @JsonProperty
    public boolean isReturnNullOnEmptyGroup() {
        return this.returnNullOnEmptyGroup;
    }

    @JsonProperty
    public Optional<String> getPushedDownAggregateFunctionName() {
        return this.pushedDownAggregateFunctionName;
    }

    @JsonProperty
    public Optional<String> getPushedDownAggregateFunctionArgument() {
        return this.pushedDownAggregateFunctionArgument;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.getColumnName(), this.getDataType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotColumnHandle that = (PinotColumnHandle)o;
        return Objects.equals(this.getColumnName(), that.getColumnName());
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).add("expression", (Object)this.expression).add("aliased", this.aliased).add("aggregate", this.aggregate).add("returnNullOnEmptyGroup", this.returnNullOnEmptyGroup).add("pushedDownaAggregateFunctionName", this.pushedDownAggregateFunctionName).add("pushedDownaAggregateFunctionArgument", this.pushedDownAggregateFunctionArgument).toString();
    }
}

