/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.decoders.ArrayDecoder;
import io.trino.plugin.pinot.decoders.BigintDecoder;
import io.trino.plugin.pinot.decoders.BooleanDecoder;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.plugin.pinot.decoders.DoubleDecoder;
import io.trino.plugin.pinot.decoders.IntegerDecoder;
import io.trino.plugin.pinot.decoders.RealDecoder;
import io.trino.plugin.pinot.decoders.VarcharDecoder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class DecoderFactory {
    protected static final String PINOT_INFINITY = "\u221e";
    protected static final String PINOT_POSITIVE_INFINITY = "+\u221e";
    protected static final String PINOT_NEGATIVE_INFINITY = "-\u221e";
    protected static final Double TRINO_INFINITY = Double.POSITIVE_INFINITY;
    protected static final Double TRINO_NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;

    private DecoderFactory() {
    }

    public static Double parseDouble(String value) {
        try {
            Objects.requireNonNull(value, "value is null");
            return Double.valueOf(value);
        }
        catch (NumberFormatException ne) {
            switch (value) {
                case "\u221e": 
                case "+\u221e": {
                    return TRINO_INFINITY;
                }
                case "-\u221e": {
                    return TRINO_NEGATIVE_INFINITY;
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_DECODE_ERROR, Optional.empty(), "Cannot decode double value from pinot " + value, ne);
        }
    }

    public static Decoder createDecoder(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (type instanceof FixedWidthType) {
            if (type instanceof DoubleType) {
                return new DoubleDecoder();
            }
            if (type instanceof RealType) {
                return new RealDecoder();
            }
            if (type instanceof BigintType) {
                return new BigintDecoder();
            }
            if (type instanceof IntegerType) {
                return new IntegerDecoder();
            }
            if (type instanceof BooleanType) {
                return new BooleanDecoder();
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
        }
        if (type instanceof ArrayType) {
            return new ArrayDecoder(type);
        }
        return new VarcharDecoder();
    }
}

