/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotMetadata;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.PinotExpressionRewriter;
import io.trino.plugin.pinot.query.PinotSqlFormatter;
import io.trino.plugin.pinot.query.PinotTypeResolver;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public final class DynamicTableBuilder {
    private static final CalciteSqlCompiler REQUEST_COMPILER = new CalciteSqlCompiler();
    public static final String OFFLINE_SUFFIX = "_OFFLINE";
    public static final String REALTIME_SUFFIX = "_REALTIME";

    private DynamicTableBuilder() {
    }

    public static DynamicTable buildFromPql(PinotMetadata pinotMetadata, SchemaTableName schemaTableName, PinotClient pinotClient) {
        Objects.requireNonNull(pinotMetadata, "pinotMetadata is null");
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        String query = schemaTableName.getTableName();
        BrokerRequest request = REQUEST_COMPILER.compileToBrokerRequest(query);
        PinotQuery pinotQuery = request.getPinotQuery();
        QueryContext queryContext = BrokerRequestToQueryContextConverter.convert((BrokerRequest)request);
        String pinotTableName = DynamicTableBuilder.stripSuffix(request.getQuerySource().getTableName());
        Optional<String> suffix = DynamicTableBuilder.getSuffix(request.getQuerySource().getTableName());
        Map<String, ColumnHandle> columnHandles = pinotMetadata.getPinotColumnHandles(pinotTableName);
        ImmutableList orderBy = ImmutableList.of();
        PinotTypeResolver pinotTypeResolver = new PinotTypeResolver(pinotClient, pinotTableName);
        Object selectColumns = ImmutableList.of();
        ImmutableMap.Builder aggregateTypesBuilder = ImmutableMap.builder();
        if (queryContext.getAggregationFunctions() != null) {
            Preconditions.checkState((queryContext.getAggregationFunctions().length > 0 ? 1 : 0) != 0, (Object)"Aggregation Functions is empty");
            for (AggregationFunction aggregationFunction : queryContext.getAggregationFunctions()) {
                aggregateTypesBuilder.put((Object)aggregationFunction.getResultColumnName(), (Object)DynamicTableBuilder.toTrinoType(aggregationFunction.getFinalResultColumnType()));
            }
        }
        ImmutableMap aggregateTypes = aggregateTypesBuilder.buildOrThrow();
        if (queryContext.getSelectExpressions() != null) {
            Preconditions.checkState((!queryContext.getSelectExpressions().isEmpty() ? 1 : 0) != 0, (Object)"Pinot selections is empty");
            selectColumns = DynamicTableBuilder.getPinotColumns(schemaTableName, queryContext.getSelectExpressions(), queryContext.getAliasList(), columnHandles, pinotTypeResolver, (Map<String, Type>)aggregateTypes);
        }
        if (queryContext.getOrderByExpressions() != null) {
            ImmutableList.Builder orderByBuilder = ImmutableList.builder();
            for (OrderByExpressionContext orderByExpressionContext : queryContext.getOrderByExpressions()) {
                ExpressionContext expressionContext = orderByExpressionContext.getExpression();
                PinotColumnHandle pinotColumnHandle = DynamicTableBuilder.getPinotColumnHandle(schemaTableName, expressionContext, Optional.empty(), columnHandles, pinotTypeResolver, (Map<String, Type>)aggregateTypes);
                orderByBuilder.add((Object)new OrderByExpression(pinotColumnHandle.getExpression(), orderByExpressionContext.isAsc()));
            }
            orderBy = orderByBuilder.build();
        }
        Object groupByColumns = ImmutableList.of();
        if (queryContext.getGroupByExpressions() != null) {
            groupByColumns = DynamicTableBuilder.getPinotColumns(schemaTableName, queryContext.getGroupByExpressions(), (List<String>)ImmutableList.of(), columnHandles, pinotTypeResolver, (Map<String, Type>)aggregateTypes);
        }
        Optional<String> filter = Optional.empty();
        if (pinotQuery.getFilterExpression() != null) {
            String formatted = PinotSqlFormatter.formatFilter(schemaTableName, queryContext.getFilter(), columnHandles);
            filter = Optional.of(formatted);
        }
        return new DynamicTable(pinotTableName, suffix, (List<PinotColumnHandle>)selectColumns, filter, (List<PinotColumnHandle>)groupByColumns, (List<PinotColumnHandle>)ImmutableList.of(), (List<OrderByExpression>)orderBy, OptionalLong.of(queryContext.getLimit()), DynamicTableBuilder.getOffset(queryContext), query);
    }

    private static Type toTrinoType(DataSchema.ColumnDataType columnDataType) {
        switch (columnDataType) {
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case INT_ARRAY: {
                return new ArrayType((Type)IntegerType.INTEGER);
            }
            case LONG_ARRAY: {
                return new ArrayType((Type)BigintType.BIGINT);
            }
            case DOUBLE_ARRAY: {
                return new ArrayType((Type)DoubleType.DOUBLE);
            }
            case STRING_ARRAY: {
                return new ArrayType((Type)VarcharType.VARCHAR);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported column data type: " + columnDataType);
    }

    private static List<PinotColumnHandle> getPinotColumns(SchemaTableName schemaTableName, List<ExpressionContext> expressions, List<String> aliases, Map<String, ColumnHandle> columnHandles, PinotTypeResolver pinotTypeResolver, Map<String, Type> aggregateTypes) {
        ImmutableList.Builder pinotColumnsBuilder = ImmutableList.builder();
        for (int index = 0; index < expressions.size(); ++index) {
            ExpressionContext expressionContext = expressions.get(index);
            Optional<String> alias = DynamicTableBuilder.getAlias(aliases, index);
            if (expressionContext.getType() == ExpressionContext.Type.IDENTIFIER && expressionContext.getIdentifier().equals("*")) {
                pinotColumnsBuilder.addAll((Iterable)columnHandles.values().stream().map(handle -> PinotColumnHandle.fromNonAggregateColumnHandle((PinotColumnHandle)handle)).collect(ImmutableList.toImmutableList()));
                continue;
            }
            pinotColumnsBuilder.add((Object)DynamicTableBuilder.getPinotColumnHandle(schemaTableName, expressionContext, alias, columnHandles, pinotTypeResolver, aggregateTypes));
        }
        return pinotColumnsBuilder.build();
    }

    private static PinotColumnHandle getPinotColumnHandle(SchemaTableName schemaTableName, ExpressionContext expressionContext, Optional<String> alias, Map<String, ColumnHandle> columnHandles, PinotTypeResolver pinotTypeResolver, Map<String, Type> aggregateTypes) {
        ExpressionContext rewritten = PinotExpressionRewriter.rewriteExpression(schemaTableName, expressionContext, columnHandles);
        String columnName = rewritten.toString();
        String pinotExpression = PinotSqlFormatter.formatExpression(schemaTableName, rewritten);
        boolean isAggregate = DynamicTableBuilder.isAggregate(rewritten);
        Type trinoType = isAggregate ? Objects.requireNonNull(aggregateTypes.get(columnName.toLowerCase(Locale.ENGLISH)), String.format("Unexpected aggregate expression: '%s'", rewritten)) : PinotColumnHandle.getTrinoTypeFromPinotType(pinotTypeResolver.resolveExpressionType(rewritten, schemaTableName, columnHandles));
        return new PinotColumnHandle(alias.orElse(columnName), trinoType, pinotExpression, alias.isPresent(), isAggregate, true, Optional.empty(), Optional.empty());
    }

    private static Optional<String> getAlias(List<String> aliases, int index) {
        if (index >= aliases.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(aliases.get(index));
    }

    private static boolean isAggregate(ExpressionContext expressionContext) {
        return expressionContext.getType() == ExpressionContext.Type.FUNCTION && expressionContext.getFunction().getType() == FunctionContext.Type.AGGREGATION;
    }

    private static OptionalLong getOffset(QueryContext queryContext) {
        if (queryContext.getOffset() > 0) {
            return OptionalLong.of(queryContext.getOffset());
        }
        return OptionalLong.empty();
    }

    private static String stripSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return tableName.substring(0, tableName.length() - OFFLINE_SUFFIX.length());
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return tableName.substring(0, tableName.length() - REALTIME_SUFFIX.length());
        }
        return tableName;
    }

    private static Optional<String> getSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return Optional.of(OFFLINE_SUFFIX);
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return Optional.of(REALTIME_SUFFIX);
        }
        return Optional.empty();
    }
}

