/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query.aggregation;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.AggregateExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.Optional;
import java.util.Set;

public class ImplementSum
implements AggregateFunctionRule<AggregateExpression> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private static final Set<Type> SUPPORTED_ARGUMENT_TYPES = ImmutableSet.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE);

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"sum")).with(AggregateFunctionPatterns.singleArgument().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(SUPPORTED_ARGUMENT_TYPES::contains)).capturedAs(ARGUMENT)));
    }

    public Optional<AggregateExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        PinotColumnHandle columnHandle = (PinotColumnHandle)context.getAssignment(argument.getName());
        return Optional.of(new AggregateExpression(aggregateFunction.getFunctionName(), (String)context.getIdentifierQuote().apply(columnHandle.getColumnName()), true));
    }
}

