/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import io.trino.tpcds.PseudoTableScalingInfos;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.SlowlyChangingDimensionUtils;
import io.trino.tpcds.Table;
import io.trino.tpcds.TpcdsException;
import io.trino.tpcds.distribution.CalendarDistribution;
import io.trino.tpcds.distribution.CatalogPageDistributions;
import io.trino.tpcds.distribution.HoursDistribution;
import io.trino.tpcds.generator.GeneratorColumn;
import io.trino.tpcds.generator.WebPageGeneratorColumn;
import io.trino.tpcds.generator.WebSiteGeneratorColumn;
import io.trino.tpcds.random.RandomNumberStream;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.type.Date;

public final class JoinKeyUtils {
    private static final int WEB_PAGES_PER_SITE = 123;
    private static final int WEB_DATE_STAGGER = 17;

    private JoinKeyUtils() {
    }

    public static long generateJoinKey(GeneratorColumn fromColumn, RandomNumberStream randomNumberStream, Table toTable, long joinCount, Scaling scaling) {
        Table fromTable = fromColumn.getTable();
        switch (toTable) {
            case CATALOG_PAGE: {
                return JoinKeyUtils.generateCatalogPageJoinKey(randomNumberStream, joinCount, scaling);
            }
            case DATE_DIM: {
                int year = RandomValueGenerator.generateUniformRandomInt(Date.DATE_MINIMUM.getYear(), Date.DATE_MAXIMUM.getYear(), randomNumberStream);
                return JoinKeyUtils.generateDateJoinKey(fromTable, randomNumberStream, fromColumn, joinCount, year, scaling);
            }
            case TIME_DIM: {
                return JoinKeyUtils.generateTimeJoinKey(fromTable, randomNumberStream);
            }
        }
        if (toTable.keepsHistory()) {
            return JoinKeyUtils.generateScdJoinKey(toTable, randomNumberStream, joinCount, scaling);
        }
        return RandomValueGenerator.generateUniformRandomKey(1L, scaling.getRowCount(toTable), randomNumberStream);
    }

    private static long generateCatalogPageJoinKey(RandomNumberStream randomNumberStream, long julianDate, Scaling scaling) {
        int pagesPerCatalog = (int)scaling.getRowCount(Table.CATALOG_PAGE) / 18 / (Date.DATE_MAXIMUM.getYear() - Date.DATE_MINIMUM.getYear() + 2);
        String type = CatalogPageDistributions.pickRandomCatalogPageType(randomNumberStream);
        int page = RandomValueGenerator.generateUniformRandomInt(1, pagesPerCatalog, randomNumberStream);
        int offset = (int)julianDate - Date.JULIAN_DATA_START_DATE - 1;
        int count = offset / 365 * 18;
        offset %= 365;
        switch (type) {
            case "bi-annual": {
                if (offset <= 183) break;
                ++count;
                break;
            }
            case "quarterly": {
                count += offset / 91;
                break;
            }
            case "monthly": {
                count += offset / 31;
                break;
            }
            default: {
                throw new TpcdsException(String.format("Invalid catalog_page_type: %s", type));
            }
        }
        return count * pagesPerCatalog + page;
    }

    private static long generateDateJoinKey(Table fromTable, RandomNumberStream randomNumberStream, GeneratorColumn fromColumn, long joinCount, int year, Scaling scaling) {
        switch (fromTable) {
            case STORE_SALES: 
            case CATALOG_SALES: 
            case WEB_SALES: {
                CalendarDistribution.Weights weights = CalendarDistribution.Weights.SALES;
                if (Date.isLeapYear(year)) {
                    weights = CalendarDistribution.Weights.SALES_LEAP_YEAR;
                }
                int dayNumber = CalendarDistribution.pickRandomDayOfYear(weights, randomNumberStream);
                int result = Date.toJulianDays(new Date(year, 1, 1)) + dayNumber;
                return result > Date.JULIAN_TODAYS_DATE ? -1L : (long)result;
            }
            case STORE_RETURNS: 
            case CATALOG_RETURNS: 
            case WEB_RETURNS: {
                return JoinKeyUtils.generateDateReturnsJoinKey(fromTable, randomNumberStream, joinCount);
            }
            case WEB_SITE: 
            case WEB_PAGE: {
                return JoinKeyUtils.generateWebJoinKey(fromColumn, randomNumberStream, joinCount, scaling);
            }
        }
        CalendarDistribution.Weights weights = CalendarDistribution.Weights.UNIFORM;
        if (Date.isLeapYear(year)) {
            weights = CalendarDistribution.Weights.UNIFORM_LEAP_YEAR;
        }
        int dayNumber = CalendarDistribution.pickRandomDayOfYear(weights, randomNumberStream);
        int result = Date.toJulianDays(new Date(year, 1, 1)) + dayNumber;
        return result > Date.JULIAN_TODAYS_DATE ? -1L : (long)result;
    }

    private static long generateWebJoinKey(GeneratorColumn fromColumn, RandomNumberStream randomNumberStream, long joinKey, Scaling scaling) {
        if (fromColumn == WebPageGeneratorColumn.WP_CREATION_DATE_SK) {
            int site = (int)(joinKey / 123L + 1L);
            long webSiteDuration = JoinKeyUtils.getWebSiteDuration(scaling);
            int minResult = (int)((long)Date.JULIAN_DATE_MINIMUM - (long)(site * 17) % webSiteDuration / 2L);
            return RandomValueGenerator.generateUniformRandomInt(minResult, Date.JULIAN_DATE_MINIMUM, randomNumberStream);
        }
        if (fromColumn == WebSiteGeneratorColumn.WEB_OPEN_DATE) {
            long webSiteDuration = JoinKeyUtils.getWebSiteDuration(scaling);
            return (long)Date.JULIAN_DATE_MINIMUM - joinKey * 17L % webSiteDuration / 2L;
        }
        if (fromColumn == WebSiteGeneratorColumn.WEB_CLOSE_DATE) {
            long webSiteDuration = JoinKeyUtils.getWebSiteDuration(scaling);
            long result = (long)Date.JULIAN_DATE_MINIMUM - joinKey * 17L % webSiteDuration / 2L;
            result += -1L * webSiteDuration;
            if (JoinKeyUtils.isReplaced(joinKey) && !JoinKeyUtils.isReplacement(joinKey)) {
                result -= -1L * webSiteDuration / 2L;
            }
            return result;
        }
        throw new TpcdsException("invalid column for web join");
    }

    private static long getWebSiteDuration(Scaling scaling) {
        return (long)(Date.JULIAN_DATE_MAXIMUM - Date.JULIAN_DATE_MINIMUM) * PseudoTableScalingInfos.CONCURRENT_WEB_SITES.getRowCountForScale(scaling.getScale());
    }

    private static boolean isReplaced(long joinKey) {
        return joinKey % 2L == 0L;
    }

    private static boolean isReplacement(long joinKey) {
        return joinKey / 2L % 2L != 0L;
    }

    private static long generateDateReturnsJoinKey(Table fromTable, RandomNumberStream randomNumberStream, long joinCount) {
        int max;
        int min;
        switch (fromTable) {
            case STORE_RETURNS: 
            case CATALOG_RETURNS: {
                min = 2;
                max = 90;
                break;
            }
            case WEB_RETURNS: {
                min = 1;
                max = 120;
                break;
            }
            default: {
                throw new TpcdsException("Invalid table for dateJoinReturns");
            }
        }
        int lag = RandomValueGenerator.generateUniformRandomInt(min * 2, max * 2, randomNumberStream);
        return joinCount + (long)lag;
    }

    private static long generateTimeJoinKey(Table fromTable, RandomNumberStream randomNumberStream) {
        int hour;
        switch (fromTable) {
            case STORE_SALES: 
            case STORE_RETURNS: {
                hour = HoursDistribution.pickRandomHour(HoursDistribution.Weights.STORE, randomNumberStream);
                break;
            }
            case CATALOG_SALES: 
            case WEB_SALES: 
            case CATALOG_RETURNS: 
            case WEB_RETURNS: {
                hour = HoursDistribution.pickRandomHour(HoursDistribution.Weights.CATALOG_AND_WEB, randomNumberStream);
                break;
            }
            default: {
                hour = HoursDistribution.pickRandomHour(HoursDistribution.Weights.UNIFORM, randomNumberStream);
            }
        }
        int seconds = RandomValueGenerator.generateUniformRandomInt(0, 3599, randomNumberStream);
        return hour * 3600 + seconds;
    }

    private static long generateScdJoinKey(Table toTable, RandomNumberStream randomNumberStream, long julianDate, Scaling scaling) {
        if (julianDate > (long)Date.JULIAN_DATA_END_DATE) {
            return -1L;
        }
        long idCount = scaling.getIdCount(toTable);
        long key = RandomValueGenerator.generateUniformRandomKey(1L, idCount, randomNumberStream);
        return (key = SlowlyChangingDimensionUtils.matchSurrogateKey(key, julianDate, toTable, scaling)) > scaling.getRowCount(toTable) ? -1L : key;
    }
}

