/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import com.google.common.base.Preconditions;
import io.trino.tpcds.TpcdsException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ScalingInfo {
    private static final double[] DEFINED_SCALES = new double[]{0.0, 1.0, 10.0, 100.0, 300.0, 1000.0, 3000.0, 10000.0, 30000.0, 100000.0};
    private int multiplier;
    private ScalingModel scalingModel;
    private Map<Double, Integer> scalesToRowCountsMap;
    private int updatePercentage;

    public ScalingInfo(int multiplier, ScalingModel scalingModel, int[] rowCountsPerScale, int updatePercentage) {
        Preconditions.checkArgument((multiplier >= 0 ? 1 : 0) != 0, (Object)"multiplier is not greater than or equal to 0");
        Preconditions.checkArgument((updatePercentage >= 0 ? 1 : 0) != 0, (Object)"updatePrecentage is not greater than or equal to zero");
        this.multiplier = multiplier;
        this.scalingModel = Objects.requireNonNull(scalingModel);
        this.updatePercentage = updatePercentage;
        Preconditions.checkArgument((rowCountsPerScale.length == DEFINED_SCALES.length ? 1 : 0) != 0);
        this.scalesToRowCountsMap = new HashMap<Double, Integer>(DEFINED_SCALES.length);
        for (int i = 0; i < rowCountsPerScale.length; ++i) {
            Preconditions.checkArgument((rowCountsPerScale[i] >= 0 ? 1 : 0) != 0, (Object)"row counts cannot be negative");
            this.scalesToRowCountsMap.put(DEFINED_SCALES[i], rowCountsPerScale[i]);
        }
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public long getRowCountForScale(double scale) {
        Preconditions.checkArgument((scale <= 100000.0 ? 1 : 0) != 0, (Object)"scale must be less than 100000");
        if (this.scalesToRowCountsMap.containsKey(scale)) {
            return this.scalesToRowCountsMap.get(scale).intValue();
        }
        switch (this.scalingModel) {
            case STATIC: {
                return this.computeCountUsingStaticScale();
            }
            case LINEAR: {
                return this.computeCountUsingLinearScale(scale);
            }
            case LOGARITHMIC: {
                return this.computeCountUsingLogScale(scale);
            }
        }
        throw new TpcdsException("unexpected value for scaling model: " + (Object)((Object)this.scalingModel));
    }

    private long computeCountUsingStaticScale() {
        return this.getRowCountForScale(1.0);
    }

    private long computeCountUsingLogScale(double scale) {
        int scaleSlot = ScalingInfo.getScaleSlot(scale);
        long delta = this.getRowCountForScale(DEFINED_SCALES[scaleSlot]) - this.getRowCountForScale(DEFINED_SCALES[scaleSlot - 1]);
        float floatOffset = (float)(scale - DEFINED_SCALES[scaleSlot - 1]) / (float)(DEFINED_SCALES[scaleSlot] - DEFINED_SCALES[scaleSlot - 1]);
        long baseRowCount = scale < 1.0 ? this.getRowCountForScale(DEFINED_SCALES[0]) : this.getRowCountForScale(DEFINED_SCALES[1]);
        long count = (long)((int)(floatOffset * (float)delta)) + baseRowCount;
        return count == 0L ? 1L : count;
    }

    private static int getScaleSlot(double scale) {
        for (int i = 0; i < DEFINED_SCALES.length; ++i) {
            if (!(scale <= DEFINED_SCALES[i])) continue;
            return i;
        }
        throw new TpcdsException("scale was greater than max scale");
    }

    private long computeCountUsingLinearScale(double scale) {
        long rowCount = 0L;
        double targetGB = scale;
        if (scale < 1.0) {
            rowCount = Math.round(scale * (double)this.getRowCountForScale(DEFINED_SCALES[1]));
            if (rowCount == 0L) {
                return 1L;
            }
            return rowCount;
        }
        for (int i = DEFINED_SCALES.length - 1; i > 0; --i) {
            while (targetGB >= DEFINED_SCALES[i]) {
                rowCount += this.getRowCountForScale(DEFINED_SCALES[i]);
                targetGB -= DEFINED_SCALES[i];
            }
        }
        return rowCount;
    }

    public static enum ScalingModel {
        STATIC,
        LINEAR,
        LOGARITHMIC;

    }
}

