/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import io.trino.tpcds.Results;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.TpcdsException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableGenerator {
    private final Session session;

    public TableGenerator(Session session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public void generateTable(Table table) {
        if (table.isChild() && !this.session.generateOnlyOneTable()) {
            return;
        }
        try (OutputStreamWriter parentWriter = this.addFileWriterForTable(table);
             OutputStreamWriter childWriter = table.hasChild() && !this.session.generateOnlyOneTable() ? this.addFileWriterForTable(table.getChild()) : null;){
            Results results = Results.constructResults(table, this.session);
            for (List<List<String>> parentAndChildRows : results) {
                if (parentAndChildRows.size() > 0) {
                    this.writeResults(parentWriter, parentAndChildRows.get(0));
                }
                if (parentAndChildRows.size() <= 1) continue;
                Objects.requireNonNull(childWriter, "childWriter is null, but a child row was produced");
                this.writeResults(childWriter, parentAndChildRows.get(1));
            }
        }
        catch (IOException e) {
            throw new TpcdsException(e.getMessage());
        }
    }

    private OutputStreamWriter addFileWriterForTable(Table table) throws IOException {
        String path = this.getPath(table);
        File file = new File(path);
        boolean newFileCreated = file.createNewFile();
        if (!newFileCreated) {
            if (this.session.shouldOverwrite()) {
                new FileOutputStream(path).close();
            } else {
                throw new TpcdsException(String.format("File %s exists.  Remove it or run with the '--overwrite' option", path));
            }
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(path, true), StandardCharsets.ISO_8859_1);
    }

    private String getPath(Table table) {
        if (this.session.getParallelism() > 1) {
            return String.format("%s%s%s_%d_%d%s", this.session.getTargetDirectory(), File.separator, table.getName(), this.session.getChunkNumber(), this.session.getParallelism(), this.session.getSuffix());
        }
        return String.format("%s%s%s%s", this.session.getTargetDirectory(), File.separator, table.getName(), this.session.getSuffix());
    }

    private void writeResults(Writer writer, List<String> values) throws IOException {
        writer.write(TableGenerator.formatRow(values, this.session));
    }

    public static String formatRow(List<String> values, Session session) {
        values = values.stream().map(value -> value != null ? value : session.getNullString()).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        char separator = session.getSeparator();
        stringBuilder.append(values.get(0));
        for (int i = 1; i < values.size(); ++i) {
            stringBuilder.append(separator);
            stringBuilder.append(values.get(i));
        }
        if (session.terminateRowsWithSeparator()) {
            stringBuilder.append(separator);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

