/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.column;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class ColumnType {
    private final Base base;
    private final Optional<Integer> precision;
    private final Optional<Integer> scale;

    private ColumnType(Base base, Optional<Integer> precision, Optional<Integer> scale) {
        if (base == Base.VARCHAR) {
            Preconditions.checkState((boolean)precision.isPresent());
        }
        if (base == Base.DECIMAL) {
            Preconditions.checkState((boolean)precision.isPresent());
            Preconditions.checkState((boolean)scale.isPresent());
        }
        this.base = base;
        this.precision = precision;
        this.scale = scale;
    }

    ColumnType(Base base, int precision, int scale) {
        this(base, Optional.of(precision), Optional.of(scale));
    }

    ColumnType(Base base, int precision) {
        this(base, Optional.of(precision), Optional.empty());
    }

    ColumnType(Base base) {
        this(base, Optional.empty(), Optional.empty());
    }

    public Base getBase() {
        return this.base;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    public Optional<Integer> getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnType that = (ColumnType)o;
        return Objects.equals((Object)this.base, (Object)that.base) && Objects.equals(this.precision, that.precision) && Objects.equals(this.scale, that.scale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.precision, this.scale});
    }

    public static enum Base {
        INTEGER,
        IDENTIFIER,
        DATE,
        DECIMAL,
        VARCHAR,
        CHAR,
        TIME;

    }
}

